<?php
// Avvia il buffer di output per evitare l'errore dei header
ob_start();

// Recupero dell'anno e del mese dai parametri GET
if (isset($_GET['anno']) && isset($_GET['mese'])) {
    $anno = $_GET['anno'];
    $mese = str_pad($_GET['mese'], 2, "0", STR_PAD_LEFT); // Mese a due cifre

    // Percorso alla cartella 'Fatture'
    $fatturePath = dirname(__DIR__) . '/Fatture'; // Si trova nella stessa directory di scarica_fatture.php

    // Verifica che il percorso sia corretto
    $cartellaAnno = $fatturePath . '/' . $anno;
    $cartellaMese = $cartellaAnno . '/' . $mese;

    // Controlla se la cartella anno esiste
    if (is_dir($cartellaAnno)) {
        // Controlla se la cartella mese esiste
        if (is_dir($cartellaMese)) {
            // Creazione file ZIP
            $zipFileName = "Fatture_{$anno}_{$mese}.zip";
            $zip = new ZipArchive();
            if ($zip->open($zipFileName, ZipArchive::CREATE | ZipArchive::OVERWRITE)) {
                $files = new RecursiveIteratorIterator(
                    new RecursiveDirectoryIterator($cartellaMese),
                    RecursiveIteratorIterator::LEAVES_ONLY
                );

                foreach ($files as $file) {
                    if (!$file->isDir()) {
                        $filePath = $file->getRealPath();
                        $relativePath = substr($filePath, strlen($cartellaMese) + 1);
                        $zip->addFile($filePath, $relativePath);
                    }
                }

                $zip->close();

                // Invia gli header per il download del file ZIP
                header('Content-Type: application/zip');
                header('Content-Disposition: attachment; filename="' . basename($zipFileName) . '"');
                header('Content-Length: ' . filesize($zipFileName));

                // Leggi e invia il contenuto del file ZIP
                readfile($zipFileName);

                // Rimuove il file ZIP dopo il download
                unlink($zipFileName);
                exit;
            } else {
                die('Errore nella creazione del file ZIP.');
            }
        } else {
            die('La cartella del mese non esiste. Verifica il percorso: ' . $cartellaMese);
        }
    } else {
        die('La cartella dell\'anno non esiste. Verifica il percorso: ' . $cartellaAnno);
    }
} else {
    die('Anno o mese non specificato.');
}

// Termina il buffer di output
ob_end_flush();
?>
