<?php
// Assicurati di includere la logica per l'autenticazione o altre misure di sicurezza necessarie

// Recupera i parametri dalla URL
$folder = $_GET['folder'] ?? '';
$filename = $_GET['filename'] ?? '';
$currentCategory = $_GET['category'] ?? '';

// Ottieni il percorso base
$baseDir = dirname(__DIR__);

// Definisci le categorie e le directory
$categories = [
    'video-free' => $baseDir . '/video-free',
    'Video-Privati' => $baseDir . '/Video-Privati'
];

// Funzione per ottenere le sotto-cartelle
function getSubfolders($directory) {
    $subfolders = [];
    $items = scandir($directory);
    foreach ($items as $item) {
        if ($item !== '.' && $item !== '..' && is_dir($directory . '/' . $item)) {
            $subfolders[] = $item;
        }
    }
    return $subfolders;
}

// Controlla se la categoria corrente è valida
if (!array_key_exists($currentCategory, $categories)) {
    die("Categoria corrente non valida.");
}
?>

<!DOCTYPE html>
<html lang="it">
<head>
    <meta charset="UTF-8">
    <title>Cambia Categoria</title>
    <script>
        function showSubfolders() {
            var category = document.getElementById('new-category').value;
            var xhr = new XMLHttpRequest();
            xhr.open('GET', 'get_subfolders.php?category=' + category, true);
            xhr.onload = function() {
                if (xhr.status === 200) {
                    var subfolderSelect = document.getElementById('subfolder');
                    subfolderSelect.innerHTML = '<option value="">Novità</option>' + xhr.responseText;
                }
            };
            xhr.send();
        }

        function handleFormSubmit(event) {
            event.preventDefault(); // Previene l'invio del modulo

            var form = document.querySelector('form');
            var formData = new FormData(form);

            var xhr = new XMLHttpRequest();
            xhr.open('POST', 'processa_cambio_categoria.php', true);
            xhr.onload = function() {
                if (xhr.status === 200) {
                    var response = xhr.responseText;

                    // Controlla se la risposta indica successo o errore
                    if (response.includes("File spostato correttamente")) {
                        // Se successo, chiudi il popup e ricarica la pagina principale
                        window.parent.closePopup();
                        window.parent.location.reload();
                    } else {
                        // Altrimenti, mostra l'errore
                        alert("Errore: " + response);
                    }
                } else {
                    alert("Errore nella richiesta AJAX.");
                }
            };
            xhr.send(formData);
        }
    </script>
</head>
<body>
    <h2>Cambia Categoria</h2>
    <form onsubmit="handleFormSubmit(event)">
        <input type="hidden" name="current-folder" value="<?php echo htmlspecialchars($folder); ?>">
        <input type="hidden" name="filename" value="<?php echo htmlspecialchars($filename); ?>">
        <input type="hidden" name="current-category" value="<?php echo htmlspecialchars($currentCategory); ?>">

        <div>
            <label for="new-category">Nuova Categoria:</label>
            <select id="new-category" name="new-category" onchange="showSubfolders()">
                <option value="">Seleziona</option>
                <option value="video-free">Pubblico</option>
                <option value="Video-Privati">Privato</option>
            </select>
        </div>
        <div>
            <label for="subfolder">Seleziona Sotto-Cartella:</label>
            <select id="subfolder" name="subfolder">
                <option value="">Novità</option>
                <!-- Le sotto-cartelle verranno popolate dinamicamente -->
            </select>
        </div>
        <button type="submit">Salva</button>
        <a href="index.php">Annulla</a>
    </form>
</body>
</html>

