<!DOCTYPE html>
<html lang="it">
<head>
    <meta charset="UTF-8">
    <title>Elimina Categoria</title>
    <script>
        function showSubfolders() {
            var category = document.getElementById('category').value;
            var xhr = new XMLHttpRequest();
            xhr.open('GET', 'get_subfolders.php?category=' + category, true);
            xhr.onload = function() {
                if (xhr.status === 200) {
                    var subfolderSelect = document.getElementById('subfolder');
                    subfolderSelect.innerHTML = '<option value="">Seleziona</option>' + xhr.responseText;
                }
            };
            xhr.send();
        }

        function handleFormSubmit(event) {
            event.preventDefault(); // Previene l'invio del modulo

            var form = document.querySelector('form');
            var formData = new FormData(form);

            var xhr = new XMLHttpRequest();
            xhr.open('POST', 'processa_eliminazione_categoria.php', true);
            xhr.onload = function() {
                if (xhr.status === 200) {
                    var response = xhr.responseText;

                    // Controlla se la risposta indica successo o errore
                    if (response.includes("Categoria eliminata correttamente")) {
                        // Se successo, chiudi il popup e ricarica la pagina principale
                        window.parent.closePopup();
                        window.parent.location.reload();
                    } else {
                        // Altrimenti, mostra l'errore
                        alert("Errore: " + response);
                    }
                } else {
                    alert("Errore nella richiesta AJAX.");
                }
            };
            xhr.send(formData);
        }
    </script>
</head>
<body>
    <h2>Elimina Categoria</h2>
    <form onsubmit="handleFormSubmit(event)">
        <div>
            <label for="category">Categoria:</label>
            <select id="category" name="category" onchange="showSubfolders()">
                <option value="">Seleziona</option>
                <option value="video-free">Pubblico</option>
                <option value="Video-Privati">Privato</option>
            </select>
        </div>
        <div>
            <label for="subfolder">Sotto-Cartella da Eliminare:</label>
            <select id="subfolder" name="subfolder">
                <option value="">Seleziona</option>
                <!-- Le sotto-cartelle verranno popolate dinamicamente -->
            </select>
        </div>
        <button type="submit">Elimina</button>
        <a href="index.php">Annulla</a>
    </form>
</body>
</html>
