<?php
// Include il codice di autenticazione e altre misure di sicurezza se necessario

// Recupera i parametri dalla URL
$category = $_GET['category'] ?? '';
$subfolder = $_GET['subfolder'] ?? '';

$baseDir = dirname(__DIR__);
$categories = [
    'video-free' => $baseDir . '/video-free',
    'Video-Privati' => $baseDir . '/Video-Privati'
];

// Verifica se la categoria è valida
if (!array_key_exists($category, $categories)) {
    die("Categoria non valida.");
}

$categoryDir = $categories[$category];
$subfolderDir = $categoryDir . '/' . $subfolder;

// Verifica se la sottocartella esiste e se è vuota
if (is_dir($subfolderDir) && count(scandir($subfolderDir)) === 2) {
    rmdir($subfolderDir);
    echo "Sottocartella eliminata correttamente: " . htmlspecialchars($subfolder);
} else {
    echo "Errore: La sottocartella non è vuota o non esiste.";
}

// Dopo aver eliminato la sottocartella, reindirizza alla pagina principale
header('Location: index.php');
exit;
?>
