<?php
// Assicurati di includere la logica per l'autenticazione o altre misure di sicurezza necessarie

// Usa $_REQUEST per prendere i parametri da POST o GET
$folder = $_REQUEST['folder'] ?? '';
$filename = $_REQUEST['filename'] ?? '';
$category = $_REQUEST['category'] ?? '';

// Definisci le categorie e le directory
$baseDir = dirname(__DIR__);
$categories = [
    'video-free' => $baseDir . '/video-free',
    'Video-Privati' => $baseDir . '/Video-Privati'
];

// Verifica se la categoria è valida
if (!isset($categories[$category])) {
    die("Errore: Categoria non valida.");
}

// Costruisci il percorso completo del file
$filePath = rtrim($categories[$category], '/') . '/' . rtrim($folder, '/') . '/' . $filename;

// Verifica se il file esiste
if (file_exists($filePath)) {
    // Elimina il file
    if (unlink($filePath)) {
        // Redirect a index.php dopo l'eliminazione
        header("Location: index.php");
        exit();
    } else {
        // Se si verifica un errore durante l'eliminazione
        echo "Errore durante l'eliminazione del file.";
    }
} else {
    echo "Il file non esiste.";
}
?>
