<?php
$baseDir = dirname(__DIR__); // Sali di un livello rispetto alla cartella "Video-Admin"
$publicDir = $baseDir . '/video-free';
$privateDir = $baseDir . '/Video-Privati';

// Funzione per ottenere il contenuto del file descriptions.txt come stringa
function getDescriptionsContent($dir) {
    $descriptionFile = $dir . '/descriptions.txt';
    if (file_exists($descriptionFile)) {
        return file_get_contents($descriptionFile);
    }
    return '';
}

// Funzione per aggiornare il file descriptions.txt con la nuova descrizione
function updateDescription($dir, $folder, $filename, $newDescription) {
    $descriptionFile = $dir . '/descriptions.txt';
    if (!file_exists($descriptionFile)) {
        file_put_contents($descriptionFile, '');
    }
    
    $content = file_get_contents($descriptionFile);
    
    // Rimuove l'entrata esistente se presente
    $pattern = "/^" . preg_quote(($folder ? $folder . '/' : '') . $filename, '/') . "=[^\n]*$/m";
    $content = preg_replace($pattern, '', $content);
    
    // Se il contenuto è vuoto, non aggiungere una nuova riga
    if (trim($content) === '') {
        $content = '';
    } else {
        $content = trim($content);
    }
    
    // Aggiunge la nuova descrizione
    $replacement = ($folder ? $folder . '/' : '') . $filename . '=' . $newDescription;
    $content .= ($content ? "\n" : '') . $replacement;
    
    file_put_contents($descriptionFile, $content);
}

// Funzione per creare una nuova cartella
function createNewFolder($baseDir, $category, $newFolderName) {
    $targetDir = $category === 'video-free' ? $baseDir . '/video-free' : $baseDir . '/Video-Privati';
    $newDirPath = $targetDir . '/' . $newFolderName;

    if (!preg_match('/^[a-zA-Z0-9]+$/', $newFolderName)) {
        echo "Nome della cartella non valido. Utilizzare solo lettere e numeri.";
        return;
    }
    
    if (!file_exists($newDirPath)) {
        mkdir($newDirPath, 0777, true);
    }
}

// Gestisce l'aggiornamento della descrizione
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['folder']) && isset($_POST['filename']) && isset($_POST['description']) && isset($_POST['category'])) {
    $folder = $_POST['folder'];
    $filename = $_POST['filename'];
    $newDescription = $_POST['description'];
    $category = $_POST['category'];
    
    $dir = $category === 'video-free' ? $publicDir : $privateDir;
    
    // Se il file si trova nella root della cartella, non includere il nome della cartella
    if ($folder === 'video-free' || $folder === 'Video-Privati') {
        $folder = '';
    }

    updateDescription($dir, $folder, $filename, $newDescription);
    header("Location: {$_SERVER['PHP_SELF']}");
    exit;
}

// Gestisce la creazione della nuova cartella
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['new_folder']) && isset($_POST['category_create'])) {
    $newFolderName = $_POST['new_folder'];
    $categoryToCreate = $_POST['category_create'];

    createNewFolder($baseDir, $categoryToCreate, $newFolderName);
    header("Location: {$_SERVER['PHP_SELF']}");
    exit;
}

function listVideosWithDescriptions($dir, $baseDir, $descriptionsContent) {
    $videos = [];
    $iterator = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($dir));
    
    foreach ($iterator as $fileInfo) {
        if ($fileInfo->isFile() && pathinfo($fileInfo, PATHINFO_EXTENSION) === 'mp4') {
            $relativePath = str_replace($baseDir . '/', '', $fileInfo->getPathname());
            $filename = $fileInfo->getFilename();
            $folderName = basename(dirname($fileInfo->getPathname()));

            // Se il file si trova nella root della cartella, non includere il nome della cartella
            if ($folderName === basename($dir)) {
                $folderName = '';
            }
            
            // Inizializza la descrizione come "Nessuna descrizione"
            $description = 'Nessuna descrizione';

            // Cerca la descrizione corrispondente nella stringa
            $pattern = "/^" . preg_quote(($folderName ? $folderName . '/' : '') . $filename, '/') . "=(.*)$/m";
            if (preg_match($pattern, $descriptionsContent, $matches)) {
                $description = $matches[1];
            }

            $videos[] = [
                'folder' => $folderName,
                'filename' => $filename,
                'description' => $description,
                'mtime' => $fileInfo->getMTime() // Aggiungi la data di modifica
            ];
        }
    }

    // Ordina i video per data di modifica (mtime), più recente prima
    usort($videos, function($a, $b) {
        return $b['mtime'] - $a['mtime']; // Ordine decrescente
    });

    // Rimuovi il campo 'mtime' dall'array per non restituirlo
    foreach ($videos as &$video) {
        unset($video['mtime']);
    }

    return $videos;
}


// Ottieni il contenuto di descriptions.txt per entrambe le cartelle
$publicDescriptionsContent = getDescriptionsContent($publicDir);
$privateDescriptionsContent = getDescriptionsContent($privateDir);

// Elenco categorie
$categories = [
    'video-free' => $publicDir,
    'Video-Privati' => $privateDir
];
?>

<!DOCTYPE html>
<html lang="it">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gestione Video</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f9f9f9;
            color: #333;
            margin: 0;
            padding: 20px;
        }
        h1 {
            font-size: 24px;
            margin-bottom: 20px;
        }
        .menu {
            margin-bottom: 20px;
        }
        .menu a {
            margin-right: 15px;
            text-decoration: none;
            color: #007BFF;
        }
        .menu a:hover {
            text-decoration: underline;
        }
        .category, .video {
            margin-bottom: 20px;
        }
        .form-control {
            margin-bottom: 10px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        table, th, td {
            border: 1px solid black;
        }
        th, td {
            padding: 10px;
            text-align: left;
        }
        .edit-btn, .add-btn {
            background-color: #007BFF;
            color: white;
            border: none;
            padding: 5px 10px;
            cursor: pointer;
        }
        .edit-btn:hover, .add-btn:hover {
            background-color: #0056b3;
        }

        /* Stili per il Popup */
        #popup-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.5);
            display: flex;
            justify-content: center;
            align-items: center;
            z-index: 1000;
            display: none;
        }
        #popup-content {
            background: #fff;
            border-radius: 8px;
            overflow: hidden;
            width: 80%;
            max-width: 800px;
            position: relative;
        }
        #popup-close {
            position: absolute;
            top: 10px;
            right: 10px;
            font-size: 24px;
            cursor: pointer;
        }
        
        /* Nuovi stili per il pulsante Carica Video */
        .upload-btn {
            padding: 10px 20px;
            background-color: #4CAF50;
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 16px;
        }
        .upload-btn:hover {
            background-color: #45a049;
        }
        
    </style>
    
    
    <script>
        function openPopup(url) {
            document.getElementById('popup-overlay').style.display = 'flex';
            document.getElementById('popup-frame').src = url;
        }

       function closePopup() {
        const popupOverlay = document.getElementById('popup-overlay');
        const popupFrame = document.getElementById('popup-frame');
        popupOverlay.style.display = 'none';
        popupFrame.src = ''; // Resetta il contenuto dell'iframe
        location.reload(); // Ricarica la pagina principale
    }
    </script>
</head>
<body>
    <h1>Gestione Video</h1>

    <!-- Popup per Cambia Categoria -->
    <div id="popup-overlay">
        <div id="popup-content">
            <span id="popup-close" onclick="closePopup()">&times;</span>
            <iframe id="popup-frame" style="width:100%; height:90vh; border:none;"></iframe>
        </div>
    </div>

    <!-- Menu -->
    <div class="menu">
        <a href="/admin/">Home Amministrazione</a>
        <a href="#">Altre Opzioni..</a>
        <button class="upload-btn" onclick="openPopup('upload.php')">Carica Video</button>
    </div>

    <!-- Mostra cartelle e file -->
    <h2>Video nelle cartelle del server ( Categorie )</h2>

    <?php foreach ($categories as $categoryName => $categoryDir): ?>
        <h3><?php echo htmlspecialchars($categoryName); ?></h3>

        <!-- Modulo per aggiungere una nuova cartella -->
        <form action="" method="post" style="margin-bottom: 20px;">
            <div class="form-control">
                <label for="new_folder"> Crea Nuova Categoria:</label>
                <input type="text" id="new_folder" name="new_folder" required>
                <input type="hidden" name="category_create" value="<?php echo htmlspecialchars($categoryName); ?>">
            </div>
            <button type="submit" class="add-btn">Aggiungi</button>
        </form>
        
        <?php
        
                echo '<a href="javascript:void(0);" class="delete-category-btn" onclick="openPopup(\'elimina_categoria.php?category=' . urlencode($categoryName) . '\');" style="display:inline-block; padding:10px 15px; border:2px solid red; color:red; text-decoration:none; border-radius:5px;">Elimina Categoria</a>';
?>

       <?php
$descriptionsContent = $categoryName === 'video-free' ? $publicDescriptionsContent : $privateDescriptionsContent;
$videos = listVideosWithDescriptions($categoryDir, $baseDir, $descriptionsContent);

if (empty($videos)) {
    echo "<p>Nessun video trovato in " . htmlspecialchars($categoryName) . ".</p>";
} else {
    echo '<table>';
    echo '<tr><th>Nome Cartella</th><th>Nome File</th><th>Descrizione</th><th>Azioni</th></tr>';
    foreach ($videos as $video) {
        echo "<tr>
            <td>" . htmlspecialchars($video['folder']) . "</td>
            <td>" . htmlspecialchars($video['filename']) . "</td>
            <td>" . htmlspecialchars($video['description']) . "</td>
            <td>
                <form action='' method='post' style='display:inline'>
                    <input type='hidden' name='folder' value='" . htmlspecialchars($video['folder']) . "'>
                    <input type='hidden' name='filename' value='" . htmlspecialchars($video['filename']) . "'>
                    <input type='hidden' name='category' value='" . htmlspecialchars($categoryName) . "'>
                    <button type='button' class='edit-btn' onclick='openEditForm(\"" . htmlspecialchars($video['folder']) . "\", \"" . htmlspecialchars($video['filename']) . "\", \"" . htmlspecialchars($video['description']) . "\", \"" . htmlspecialchars($categoryName) . "\")'>Modifica Descrizione</button>
                </form>";

        // Qui parte l'output HTML dentro il blocco PHP per i due link
        echo '<a href="javascript:void(0);" class="change-category-btn" onclick="openPopup(\'cambia_categoria.php?folder=' . urlencode($video['folder']) . '&filename=' . urlencode($video['filename']) . '&category=' . urlencode($categoryName) . '\');" style="display:inline-block; padding:10px 15px; border:2px solid green; color:green; text-decoration:none; border-radius:5px;">Cambia Categoria al Video</a>';

        echo '<a href="javascript:void(0);" class="delete-video-btn" onclick="confirmDelete(\'' . htmlspecialchars($video['filename']) . '\', \'' . htmlspecialchars($video['folder']) . '\', \'' . htmlspecialchars($categoryName) . '\');" style="display:inline-block; padding:10px 15px; border:2px solid red; color:red; text-decoration:none; border-radius:5px;">Elimina Video</a>';


        echo "</td>
            </tr>";
    }
    echo '</table>';
}


?>

<br><br>


<script>
function openEditForm(folder, filename, description, categoryName) {
    // Crea l'elemento del popup per la modifica della descrizione
    var popupContent = `
        <div id="edit-form-popup" style="position:fixed; bottom:20px; left:20px; padding:20px; background:white; border:1px solid #ccc; box-shadow:0 0 10px rgba(0,0,0,0.1);">
            <h3>Modifica Descrizione</h3>
            <form id="edit-form" action='index.php' method='post'>
                <input type='hidden' name='folder' value='` + folder + `'>
                <input type='hidden' name='filename' value='` + filename + `'>
                <input type='hidden' name='category' value='` + categoryName + `'>
                <label for='description'>Descrizione:</label>
                <input type='text' name='description' id='description' value='` + description + `' maxlength='120' style='width:100%;'>
                <br>
                <button type='submit'>Salva</button>
                <button type='button' onclick='document.getElementById("edit-form-popup").remove();'>Annulla</button>
            </form>
        </div>
    `;
    
    // Inserisce il popup nella pagina
    document.body.insertAdjacentHTML('beforeend', popupContent);
}
</script>




<script>
function confirmDeleteCategory(categoryName) {
    if (confirm("Sicuro di voler eliminare la categoria '" + categoryName + "'?")) {
        // Reindirizza alla pagina di eliminazione della categoria
        window.location.href = 'elimina_categoria.php?category=' + encodeURIComponent(categoryName);
    }
}
</script>
        
        <script>
    function confirmDelete(filename, folder, category) {
        if (confirm('Sicuro di voler eliminare il file "' + filename + '"?')) {
            // Se confermato, effettua l'azione di eliminazione
            window.location.href = 'elimina_video.php?folder=' + encodeURIComponent(folder) + '&filename=' + encodeURIComponent(filename) + '&category=' + encodeURIComponent(category);
        }
    }
</script>


    <?php endforeach; ?>

    <!-- Modifica Descrizione -->
    <div id="edit-form" style="display:none; margin-top:20px;">
        <h3>Modifica Descrizione</h3>
        <form action="" method="post">
            <div class="form-control">
                <label for="folder">Nome Cartella:</label>
                <input type="text" id="folder" name="folder" readonly>
            </div>
            <div class="form-control">
                <label for="filename">Nome File:</label>
                <input type="text" id="filename" name="filename" readonly>
            </div>
            <div class="form-control">
                <label for="description">Descrizione:</label>
                <textarea id="description" name="description" rows="4" cols="50"></textarea>
            </div>
            <input type="hidden" name="category" id="category">
            <button type="submit">Salva</button>
            <button type="button" onclick="hideEditForm()">Annulla</button>
        </form>
    </div>

    <script>
        function showEditForm(folder, filename, description, category) {
            document.getElementById('folder').value = folder;
            document.getElementById('filename').value = filename;
            document.getElementById('description').value = description;
            document.getElementById('category').value = category;
            document.getElementById('edit-form').style.display = 'block';
        }

        function hideEditForm() {
            document.getElementById('edit-form').style.display = 'none';
        }
    </script>
    
    
</body>
</html>

