<?php
// Assicurati di includere la logica per l'autenticazione o altre misure di sicurezza necessarie

// Recupera i parametri dal modulo
$category = $_POST['category'] ?? '';
$subfolder = $_POST['subfolder'] ?? '';

// Definisci le categorie e le directory
$categories = [
    'video-free' => dirname(__DIR__) . '/video-free',
    'Video-Privati' => dirname(__DIR__) . '/Video-Privati'
];

// Verifica se la categoria è valida
if (!array_key_exists($category, $categories)) {
    echo "Categoria non valida.";
    exit;
}

// Verifica se la sotto-cartella è specificata
if (empty($subfolder)) {
    echo "Sotto-cartella non specificata.";
    exit;
}

// Costruisci il percorso della sotto-cartella
$folderPath = $categories[$category] . '/' . $subfolder;

// Controlla se la sotto-cartella esiste e se è vuota
if (is_dir($folderPath)) {
    $files = array_diff(scandir($folderPath), array('.', '..'));
    if (empty($files)) {
        // Elimina la sotto-cartella
        rmdir($folderPath);
        echo "Categoria eliminata correttamente.";
    } else {
        echo "La sotto-cartella non è vuota. Elimina prima tutti i file.";
    }
} else {
    echo "Sotto-cartella non trovata.";
}
?>
