<?php
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Controlla che il file sia stato caricato correttamente
    if (isset($_FILES['video']) && $_FILES['video']['error'] === UPLOAD_ERR_OK) {
        $video = $_FILES['video'];
        $folder = $_POST['folder'];

        // Controlla che la cartella sia valida
        $validFolders = ['video-free', 'Video-Privati'];
        if (!in_array($folder, $validFolders)) {
            http_response_code(400);
            echo json_encode(['success' => false, 'message' => 'Cartella non valida!']);
            exit;
        }

        // Genera un nome univoco per il file
        $extension = pathinfo($video['name'], PATHINFO_EXTENSION);
        $uniqueName = uniqid('video_', true) . '.' . $extension;

        // Percorso finale
        $uploadDir = __DIR__ . '/../' . $folder; // Risale di un livello
        $uploadPath = $uploadDir . '/' . $uniqueName;

        // Sposta il file nella cartella corretta
        if (move_uploaded_file($video['tmp_name'], $uploadPath)) {
            http_response_code(200);
            echo json_encode(['success' => true, 'message' => 'File caricato con successo!']);
        } else {
            http_response_code(500);
            echo json_encode(['success' => false, 'message' => 'Errore nel caricamento del file!']);
        }
    } else {
        http_response_code(400);
        echo json_encode(['success' => false, 'message' => 'Nessun file caricato o errore nel file!']);
    }
    exit;
}
?>

<!DOCTYPE html>
<html lang="it">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Caricamento Video</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f9f9f9;
            color: #333;
            margin: 0;
            padding: 20px;
        }
        h1 {
            font-size: 24px;
        }
        .progress-container {
            margin-top: 20px;
            width: 100%;
            background-color: #ddd;
            border-radius: 8px;
            overflow: hidden;
            height: 20px;
        }
        .progress-bar {
            width: 0;
            height: 100%;
            background-color: #4CAF50;
            text-align: center;
            line-height: 20px;
            color: white;
            font-size: 14px;
        }
        .success-message {
            margin-top: 20px;
            color: green;
            font-size: 16px;
            display: none;
        }
        .error-message {
            margin-top: 20px;
            color: red;
            font-size: 16px;
            display: none;
        }
    </style>
</head>
<body>
    <h1>Carica un video</h1>
    <form id="upload-form" enctype="multipart/form-data" method="post">
        <label for="video-file">Scegli un file video (.mp4):</label>
        <input type="file" id="video-file" name="video" accept=".mp4" required>
        <br><br>
        <label for="folder">Scegli la cartella:</label>
        <select id="folder" name="folder" required>
            <option value="video-free">Video Gratuiti</option>
            <option value="Video-Privati">Video Privati</option>
        </select>
        <br><br>
        <button type="submit">Carica</button>
    </form>

    <div class="progress-container" style="display:none;">
        <div class="progress-bar" id="progress-bar">0%</div>
    </div>

    <p class="success-message" id="success-message">Upload eseguito! Chiusura in 3 secondi...</p>
    <p class="error-message" id="error-message">Errore durante l'upload. Riprova.</p>

    <script>
        const form = document.getElementById('upload-form');
        const progressBar = document.getElementById('progress-bar');
        const progressContainer = document.querySelector('.progress-container');
        const successMessage = document.getElementById('success-message');
        const errorMessage = document.getElementById('error-message');

        form.addEventListener('submit', function(event) {
            event.preventDefault(); // Previene il normale invio del modulo

            const formData = new FormData(form);
            const xhr = new XMLHttpRequest();

            // Mostra la barra di progresso
            progressContainer.style.display = 'block';

            // Aggiorna la barra di progresso durante l'upload
            xhr.upload.addEventListener('progress', function(event) {
                if (event.lengthComputable) {
                    const percent = Math.round((event.loaded / event.total) * 100);
                    progressBar.style.width = percent + '%';
                    progressBar.textContent = percent + '%';
                }
            });

            // Gestisci il completamento dell'upload
            xhr.onload = function() {
                if (xhr.status === 200) {
                    const response = JSON.parse(xhr.responseText);
                    if (response.success) {
                        progressBar.style.width = '100%';
                        progressBar.textContent = '100%';

                        // Mostra il messaggio di successo
                        successMessage.style.display = 'block';

                        // Chiudi il popup dopo 3 secondi
                        setTimeout(function() {
                            window.parent.closePopup(); // Chiama closePopup() nella pagina principale
                        }, 3000);
                    } else {
                        errorMessage.textContent = response.message;
                        errorMessage.style.display = 'block';
                    }
                } else {
                    errorMessage.textContent = 'Errore durante l\'upload!';
                    errorMessage.style.display = 'block';
                }
            };

            // Gestisci errori
            xhr.onerror = function() {
                errorMessage.textContent = 'Errore di rete!';
                errorMessage.style.display = 'block';
            };

            // Invia il modulo tramite AJAX
            xhr.open('POST', 'upload.php');
            xhr.send(formData);
        });
    </script>
</body>
</html>
