<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Lista Aziende</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 20px;
            padding: 0;
            background-color: #f4f4f4;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 20px 0;
            background-color: #fff;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        th {
            background-color: #007bff;
            color: white;
        }
        tr:nth-child(even) {
            background-color: #f2f2f2;
        }
        h1 {
            text-align: center;
            color: #333;
        }
        .pagination {
            text-align: center;
            margin: 20px 0;
        }
        .pagination a {
            margin: 0 5px;
            padding: 10px;
            background-color: #007bff;
            color: white;
            text-decoration: none;
            border-radius: 5px;
        }
        .pagination a.active {
            background-color: #0056b3;
        }
        .pagination a:hover {
            background-color: #0056b3;
        }
    </style>
</head>
<body>
    <h1>LISTA AZIENDE CON LA NOTRA VISIONE DEL MONDO</h1>

    <?php
    const DB_SERVER = 'localhost'; 
    const DB_USER = 'brokerso_atena2030'; 
	 const DB_PASS = 'Login.Atena'; 
	 const DB_DATABASE = 'brokerso_atena2030';
	 const DB_DRIVER = 'mysql';

    // Configurazione della paginazione
$perPage = isset($_GET['perPage']) ? (int)$_GET['perPage'] : 10;
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$sort = isset($_GET['sort']) ? $_GET['sort'] : 'provincia'; // Default sorting

// Gestione dei parametri per la query
$start = ($page - 1) * $perPage;
$orderBy = ($sort === 'profession' ? 'pr.field_value' : 'p.field_value');

// Query per recuperare i dati
$query = "
    SELECT u.id, u.fname AS nome, u.lname AS cognome, u.email, 
           p.field_value AS provincia, 
           pr.field_value AS professione
    FROM users u
    LEFT JOIN user_custom_fields p ON u.id = p.user_id AND p.field_id = 1
    LEFT JOIN user_custom_fields pr ON u.id = pr.user_id AND pr.field_id = 2
    WHERE u.membership_id >= 2
      AND p.field_value IS NOT NULL 
      AND pr.field_value IS NOT NULL
    ORDER BY $orderBy
    LIMIT :start, :perPage;
";

try {
    $dsn = DB_DRIVER . ":host=" . DB_SERVER . ";dbname=" . DB_DATABASE;
    $pdo = new PDO($dsn, DB_USER, DB_PASS);
    $stmt = $pdo->prepare($query);
    $stmt->bindValue(':start', $start, PDO::PARAM_INT);
    $stmt->bindValue(':perPage', $perPage, PDO::PARAM_INT);
    $stmt->execute();
    $data = $stmt->fetchAll(PDO::FETCH_OBJ);
    
    // Calcolare il numero totale di record per la paginazione
    $totalQuery = "
        SELECT COUNT(*) AS total
        FROM users u
        LEFT JOIN user_custom_fields p ON u.id = p.user_id AND p.field_id = 1
        LEFT JOIN user_custom_fields pr ON u.id = pr.user_id AND pr.field_id = 2
        WHERE u.membership_id > 2
          AND p.field_value IS NOT NULL 
          AND pr.field_value IS NOT NULL;
    ";
    $totalStmt = $pdo->query($totalQuery);
    $totalRecords = $totalStmt->fetch(PDO::FETCH_OBJ)->total;
    $totalPages = ceil($totalRecords / $perPage);
} catch (PDOException $e) {
    echo '<p>Database error: ' . htmlspecialchars($e->getMessage(), ENT_QUOTES, 'UTF-8') . '</p>';
    exit;
}

if (!empty($data)) {
    echo '<table>';
    echo '<thead><tr>';
    echo '<th><a href="?sort=provincia&perPage=' . $perPage . '&page=' . $page . '">Provincia</a></th>';
    echo '<th><a href="?sort=profession&perPage=' . $perPage . '&page=' . $page . '">Professione</a></th>';
    echo '<th>Nome</th>';
    echo '<th>Cognome</th>';
    echo '<th>Email</th>'; // Nuova colonna Email
    echo '</tr></thead>';
    echo '<tbody>';
    foreach ($data as $user) {
        echo '<tr>';
        echo '<td>' . htmlspecialchars($user->provincia, ENT_QUOTES, 'UTF-8') . '</td>';
        echo '<td>' . htmlspecialchars($user->professione, ENT_QUOTES, 'UTF-8') . '</td>';
        echo '<td>' . htmlspecialchars($user->nome, ENT_QUOTES, 'UTF-8') . '</td>';
        echo '<td>' . htmlspecialchars($user->cognome, ENT_QUOTES, 'UTF-8') . '</td>';
        echo '<td>' . htmlspecialchars($user->email, ENT_QUOTES, 'UTF-8') . '</td>'; // Visualizzazione dell'email
        echo '</tr>';
    }
    echo '</tbody>';
    echo '</table>';
} else {
    echo '<p>Nessun utente trovato.</p>';
}

// Paginazione
echo '<div class="pagination">';
for ($i = 1; $i <= $totalPages; $i++) {
    $active = ($i === $page) ? 'active' : '';
    echo '<a href="?sort=' . $sort . '&perPage=' . $perPage . '&page=' . $i . '" class="' . $active . '">' . $i . '</a>';
}
echo '</div>';
?>