<?php
// Funzione per elencare file e cartelle in una directory specifica
function listFilesAndDirectories($dir) {
    // Verifica se la directory esiste
    if (is_dir($dir)) {
        // Ottieni tutti i file e le cartelle nella directory
        $files = scandir($dir);

        // Cicla attraverso i contenuti della directory
        foreach ($files as $file) {
            // Salta '.' e '..' che sono le voci predefinite di ogni cartella
            if ($file != '.' && $file != '..') {
                // Controlla se è una cartella o un file
                if (is_dir($dir . '/' . $file)) {
                    echo "Cartella: " . $file . "<br>";
                } else {
                    echo "File: " . $file . "<br>";
                }
            }
        }
    } else {
        echo "La directory non esiste.";
    }
}

// Directory da elencare (uploads)
$dir = __DIR__ . '/uploads';
echo "<h2>Contenuto della cartella 'uploads':</h2>";
listFilesAndDirectories($dir);
?>
