<?php
// Imposta il tempo limite dello script e la memoria massima
set_time_limit(0);
ini_set('memory_limit', '512M');

// Percorso della cartella corrente (dove si trova lo script)
$incomingDir = __DIR__;

// Percorsi delle cartelle di destinazione
$videoPrivatiDir = dirname(__DIR__) . '/Video-Privati';
$videoFreeDir = dirname(__DIR__) . '/video-free';

// Funzione per spostare i file
function moveOldFiles($dir, $destinationDir, $prefix, $ageInMinutes) {
    $files = glob($dir . '/' . $prefix . '*.mp4');
    $currentTime = time();
    foreach ($files as $file) {
        if (is_file($file)) {
            $fileCreationTime = filemtime($file);
            $fileAge = ($currentTime - $fileCreationTime) / 60; // età del file in minuti
            if ($fileAge > $ageInMinutes) {
                $filename = basename($file);
                $destinationPath = $destinationDir . '/' . $filename;
                if (rename($file, $destinationPath)) {
                    echo "File spostato: $filename\n";
                } else {
                    echo "Errore nello spostamento del file: $filename\n";
                }
            }
        }
    }
}

// Sposta i file più vecchi di 2 minuti che iniziano con "privato"
moveOldFiles($incomingDir, $videoPrivatiDir, 'privato', 2);

// Sposta i file più vecchi di 2 minuti che iniziano con "streamkey"
moveOldFiles($incomingDir, $videoFreeDir, 'streamkey', 2);
?>
