<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

use Stripe\Exception\ApiErrorException;
use Stripe\Exception\CardException;
use Stripe\PaymentIntent;
use Stripe\Stripe;

if (!defined('_WOJO')) {
    die('Direct access to this location is not allowed.');
}

if (!class_exists('Cron')) {

class Cron
{
    public static function run(int $days): void
    {
        echo "Inizio elaborazione rinnovi...\n";
        
        $data = self::expireMemberships($days);
        echo "Scaduti elaborati:\n";
        var_dump($data);
        
        echo "Eseguo Stripe...\n";
        self::runStripe();
        
        echo "Invio email...\n";
        self::sendEmails($data);
        
        echo "Processo completato.\n";
    }

    public static function expireMemberships(int $days): mixed
    {
        echo "Cerco utenti con abbonamento in scadenza...\n";
        
        $sql = "SELECT u.id, CONCAT(u.fname,' ',u.lname) as fullname, u.email, u.mem_expire, m.id AS mid
                FROM " . User::mTable . " as u
                LEFT JOIN " . Membership::mTable . " AS m ON m.id = u.membership_id
                WHERE u.active = ?
                AND u.membership_id <> 0
                AND u.mem_expire <= DATE_ADD(DATE(NOW()), INTERVAL $days DAY)";
        
        $result = Database::Go()->rawQuery($sql, array('y'))->run();
        echo "Query utenti in scadenza eseguita:\n";
        var_dump($result);
        
        if ($result) {
            echo "Aggiorno utenti con abbonamento scaduto...\n";
            $query = 'UPDATE ' . User::mTable . ' SET mem_expire = NULL, membership_id = CASE ';
            $id_list = '';
            foreach ($result as $usr) {
                $query .= ' WHEN id = ' . $usr->id . ' THEN 0';
                $id_list .= $usr->id . ',';
            }
            $id_list = rtrim($id_list, ',');
            $query .= ' END WHERE id IN (' . $id_list . ')';
            Database::Go()->rawQuery($query)->run();
        }
        
        return $result;
    }

    public static function runStripe(): void
{
    echo "Cerco utenti da rinnovare...\n";

    $sql = "SELECT u.id AS uid, CONCAT(u.fname,' ',u.lname) as fullname, u.email, cj.amount, 
                   cj.id as cid, cj.membership_id, cj.stripe_customer, cj.stripe_pm
            FROM " . Core::cjTable . " as cj
            LEFT JOIN " . User::mTable . " as u ON u.id = cj.user_id
            WHERE u.active = ?
            AND DATE(cj.renewal) = CURDATE()";

    $data = Database::Go()->rawQuery($sql, array('y'))->run();
    echo "Query utenti da rinnovare eseguita:\n";
    var_dump($data);

    require_once BASEPATH . '/gateways/stripe/vendor/autoload.php';
    $key = Database::Go()->select(Core::gTable)->where('name', 'stripe', '=')->first()->run();
    Stripe::setApiKey($key->extra);

    if ($data) {
        try {
            foreach ($data as $row) {
                echo "Processo pagamento per: {$row->fullname} ({$row->email})\n";

                // Esegui il pagamento con Stripe
                $paymentIntent = PaymentIntent::create([
                    'amount' => round($row->amount * 100),
                    'currency' => $key->extra2,
                    'customer' => $row->stripe_customer,
                    'payment_method' => $row->stripe_pm,
                    'off_session' => true,
                    'confirm' => true,
                ]);

                echo "Pagamento effettuato per {$row->fullname}\n";

                // Inserire transazione in 'payments'
                $paymentData = [
                    'txn_id' => $paymentIntent->id,
                    'membership_id' => $row->membership_id,
                    'user_id' => $row->uid,
                    'rate_amount' => $row->amount,
                    'total' => $row->amount,
                    'currency' => $key->extra2,
                    'pp' => 'Stripe',
                    'status' => 1,
                ];
                $last_id = Database::Go()->insert(Membership::pTable, $paymentData)->run();
                echo "Pagamento registrato in 'payments' con ID: {$last_id}\n";

                // Calcola nuova data di scadenza
                $new_expire = Membership::calculateDays($row->membership_id);
                echo "Nuova data di scadenza: {$new_expire}\n";

                // Aggiorna 'user_membership'
                Database::Go()->insert(Membership::umTable, [
                    'transaction_id' => $last_id,
                    'user_id' => $row->uid,
                    'membership_id' => $row->membership_id,
                    'expire' => $new_expire,
                    'recurring' => 1,
                    'active' => 1,
                ])->run();
                echo "Aggiornato 'user_membership' per utente {$row->uid}\n";

                // Aggiorna 'users' con nuova scadenza
                Database::Go()->update(User::mTable, [
                    'mem_expire' => $new_expire,
                    'membership_id' => $row->membership_id
                ])->where('id', $row->uid, '=')->run();
                echo "Aggiornato 'users' per utente {$row->uid}\n";

                // Aggiorna 'cronjobs' con nuova data di rinnovo
                Database::Go()->update(Core::cjTable, [
                    'renewal' => $new_expire
                ])->where('id', $row->cid, '=')->run();
                echo "Aggiornato 'cronjobs' per ID {$row->cid}\n";
            }

        } catch (CardException $e) {
                echo "Errore Stripe per {$row->fullname}: " . $e->getMessage() . "\n";
                
                // Se il pagamento fallisce, rimuovi l'abbonamento
                Database::Go()->update(User::mTable, array(
                    'membership_id' => 0,
                    'mem_expire' => NULL
                ))->where('id', $row->uid, '=')->run();

                echo "Abbonamento rimosso per {$row->fullname}\n";
            }
    }
}

    public static function sendEmails(mixed $data): void
    {
        if ($data) {
            echo "Invio email di rinnovo...\n";
            var_dump($data);
            
            $core = App::Core();
            $body = "I seguenti account hanno provato a rinnovare l'abbonamento, controlla su Stripe l'esito finale:\n\n";
            foreach ($data as $row) {
                $body .= "Nome: {$row->fullname}, Email: {$row->email}\n";
            }
            
            $mailer = Mailer::sendMail();
            $mailer->Subject = "Rinnovi Abbonamenti";
            $mailer->setFrom($core->site_email, $core->company);
            $mailer->isHTML(false);
            $mailer->Body = $body;
            $mailer->addAddress($core->site_email, "Admin");
            
            try {
                $mailer->send();
                echo "Email inviata con successo.\n";
            } catch (Exception $e) {
                echo "Errore nell'invio dell'email: " . $e->getMessage() . "\n";
            }
        }
    }
}
    
}
