<?php
$incomingDir = 'incoming'; // Sostituisci con il percorso corretto
$videoFreeDir = 'video-free'; // Sostituisci con il percorso corretto

// Controlla se le directory esistono
if (!is_dir($incomingDir) || !is_dir($videoFreeDir)) {
    die('Una delle directory non esiste.');
}

// Ottiene la lista dei file nella cartella 'incoming'
$files = scandir($incomingDir);

foreach ($files as $file) {
    // Ignora '.' e '..'
    if ($file == '.' || $file == '..') {
        continue;
    }

    $filePath = $incomingDir . '/' . $file;
    $newPath = $videoFreeDir . '/' . $file;

    // Verifica se è un file e non una directory
    if (is_file($filePath)) {
        // Sposta il file nella cartella 'video-free'
        if (rename($filePath, $newPath)) {
            echo "File '$file' spostato correttamente.\n";
        } else {
            echo "Errore nello spostamento del file '$file'.\n";
        }
    }
}
