<?php
// Includi il file di configurazione e la connessione al database
require_once 'lib/config.ini.php'; // Modifica il percorso in base alla tua struttura

// Esegui la query per recuperare i dati
$query = "
    SELECT u.id, u.fname AS nome, u.lname AS cognome, 
           p.field_value AS provincia, 
           pr.field_value AS professione
    FROM users u
    LEFT JOIN user_custom_fields p ON u.id = p.user_id AND p.field_id = 1
    LEFT JOIN user_custom_fields pr ON u.id = pr.user_id AND pr.field_id = 2
    WHERE p.field_value IS NOT NULL 
      AND pr.field_value IS NOT NULL;
";

// Esegui la query e recupera i risultati
try {
    $pdo = new PDO('your_dsn', 'your_username', 'your_password'); // Modifica con le tue credenziali
    $stmt = $pdo->query($query);
    $data = $stmt->fetchAll(PDO::FETCH_OBJ);
} catch (PDOException $e) {
    echo 'Database error: ' . $e->getMessage();
    exit;
}

// Verifica se ci sono risultati
if (!empty($data)) {
    echo '<table border="1">';
    echo '<thead><tr><th>Nome</th><th>Cognome</th><th>Provincia</th><th>Professione</th></tr></thead>';
    echo '<tbody>';
    foreach ($data as $user) {
        echo '<tr>';
        echo '<td>' . htmlspecialchars($user->nome, ENT_QUOTES, 'UTF-8') . '</td>';
        echo '<td>' . htmlspecialchars($user->cognome, ENT_QUOTES, 'UTF-8') . '</td>';
        echo '<td>' . htmlspecialchars($user->provincia, ENT_QUOTES, 'UTF-8') . '</td>';
        echo '<td>' . htmlspecialchars($user->professione, ENT_QUOTES, 'UTF-8') . '</td>';
        echo '</tr>';
    }
    echo '</tbody>';
    echo '</table>';
} else {
    echo '<p>Nessun utente trovato.</p>';
}
