<?php
// Abilita la visualizzazione degli errori
ini_set('display_errors', 1);
error_reporting(E_ALL);

// Avvia la sessione
session_start();

// Verifica se l'utente è autenticato (ID utente presente nella sessione)
if (isset($_SESSION['user_id'])) {
    // Visualizza il session ID (identificatore unico della sessione)
    echo "<h2>Sessione attiva</h2>";
    echo "ID della sessione PHP: " . session_id() . "<br>";

    // Opzionale: mostra anche l'ID dell'utente salvato nella sessione
    echo "ID utente autenticato: " . htmlspecialchars($_SESSION['user_id']) . "<br>";
} else {
    // Se l'utente non è autenticato, reindirizza al login
    header("Location: login.php");  // Sostituisci con il percorso del tuo file di login
    exit();
}
?>
