<?php
// Avvia il buffer di output per evitare l'errore dei header
ob_start();

// Recupero dell'anno e del mese dai parametri GET
if (isset($_GET['anno']) && isset($_GET['mese'])) {
    $anno = $_GET['anno'];
    $mese = str_pad($_GET['mese'], 2, "0", STR_PAD_LEFT); // Mese a due cifre

    // Mappatura dei numeri dei mesi ai nomi in italiano
    $mesiNomi = [
        '01' => 'Gennaio',
        '02' => 'Febbraio',
        '03' => 'Marzo',
        '04' => 'Aprile',
        '05' => 'Maggio',
        '06' => 'Giugno',
        '07' => 'Luglio',
        '08' => 'Agosto',
        '09' => 'Settembre',
        '10' => 'Ottobre',
        '11' => 'Novembre',
        '12' => 'Dicembre',
    ];

    // Recupera il nome del mese dal numero
    $nomeMese = $mesiNomi[$mese] ?? 'Mese Sconosciuto';

    // Percorso alla cartella 'certificati'
    $fatturePath = dirname(__DIR__) . '/certificati'; // Si trova nella stessa directory di scarica_certificati.php

    // Verifica che il percorso sia corretto
    $cartellaAnno = $fatturePath . '/' . $anno;
    $cartellaMese = $cartellaAnno . '/' . $mese;

    // Controlla se la cartella anno esiste
    if (is_dir($cartellaAnno)) {
        // Controlla se la cartella mese esiste
        if (is_dir($cartellaMese)) {
            // Creazione file ZIP
            $zipFileName = "Certificati-{$nomeMese}-{$anno}.zip";
            $zip = new ZipArchive();

            if ($zip->open($zipFileName, ZipArchive::CREATE | ZipArchive::OVERWRITE)) {
                $files = new RecursiveIteratorIterator(
                    new RecursiveDirectoryIterator($cartellaMese, RecursiveDirectoryIterator::SKIP_DOTS),
                    RecursiveIteratorIterator::SELF_FIRST
                );

                foreach ($files as $file) {
                    $filePath = $file->getRealPath();
                    $relativePath = substr($filePath, strlen($cartellaMese) + 1);

                    // Aggiunge file e directory al file ZIP
                    if ($file->isDir()) {
                        $zip->addEmptyDir($relativePath); // Aggiungi la directory
                    } else {
                        $zip->addFile($filePath, $relativePath); // Aggiungi il file
                    }
                }

                $zip->close();

                // Invia gli header per il download del file ZIP
                header('Content-Type: application/zip');
                header('Content-Disposition: attachment; filename="' . basename($zipFileName) . '"');
                header('Content-Length: ' . filesize($zipFileName));

                // Leggi e invia il contenuto del file ZIP
                readfile($zipFileName);

                // Rimuove il file ZIP dopo il download
                unlink($zipFileName);
                exit;
            } else {
                die('Errore nella creazione del file ZIP.');
            }
        } else {
            die('La cartella del mese non esiste ancora.');
        }
    } else {
        die('La cartella dell\'anno non esiste ancora.');
    }
} else {
    die('Anno o mese non specificato.');
}

// Termina il buffer di output
ob_end_flush();
?>
