<?php
$target_dir = "tmp/"; // La cartella in cui salvare le immagini
$uploadOk = 1;

// Verifica se il file è stato caricato
if (isset($_FILES["file"])) { 
    // Se il file è un array, gestiscilo
    if (is_array($_FILES["file"]["tmp_name"])) {
        $fileCount = count($_FILES["file"]["tmp_name"]);
        for ($i = 0; $i < $fileCount; $i++) {
            // Controllo errori per il file attuale
            if ($_FILES["file"]["error"][$i] !== UPLOAD_ERR_OK) {
                echo 'Errore nel caricamento del file: ' . $_FILES["file"]["error"][$i];
                exit;
            }
            // Controlla se il file è un'immagine
            $check = getimagesize($_FILES["file"]["tmp_name"][$i]);
            if ($check === false) {
                echo 'Il file non è un’immagine.';
                exit;
            }
            // Controlla la dimensione del file (limite di 2 MB)
            if ($_FILES["file"]["size"][$i] > 2000000) {
                echo 'Il file deve essere minore di 2 MB.';
                exit;
            }
            // Consenti solo formati specifici
            $imageFileType = strtolower(pathinfo($_FILES["file"]["name"][$i], PATHINFO_EXTENSION));
            if (!in_array($imageFileType, ['jpg', 'jpeg', 'png', 'gif'])) {
                echo 'Solo file JPG, JPEG, PNG e GIF sono consentiti.';
                exit;
            }
            // Genera un nome unico per il file
            $newFileName = uniqid('img_', true) . '.' . $imageFileType;
            $target_file = $target_dir . $newFileName;

            // Prova a spostare il file caricato nella directory di destinazione
            if (move_uploaded_file($_FILES["file"]["tmp_name"][$i], $target_file)) {
                // Restituisci il link del file caricato
                echo 'http://' . $_SERVER['HTTP_HOST'] . '/uploads/news/tmp/' . basename($target_file);
            } else {
                echo 'Errore nel caricamento!';
            }
        }
    } else {
        // Se il file non è in un array
        if ($_FILES["file"]["error"] !== UPLOAD_ERR_OK) {
            echo 'Errore nel caricamento del file: ' . $_FILES["file"]["error"];
            exit;
        }
        // Controlla se il file è un'immagine
        $check = getimagesize($_FILES["file"]["tmp_name"]);
        if ($check === false) {
            echo 'Il file non è un’immagine.';
            exit;
        }
        // Controlla la dimensione del file (limite di 2 MB)
        if ($_FILES["file"]["size"] > 2000000) {
            echo 'Il file deve essere minore di 2 MB.';
            exit;
        }
        // Consenti solo formati specifici
        $imageFileType = strtolower(pathinfo($_FILES["file"]["name"], PATHINFO_EXTENSION));
        if (!in_array($imageFileType, ['jpg', 'jpeg', 'png', 'gif'])) {
            echo 'Solo file JPG, JPEG, PNG e GIF sono consentiti.';
            exit;
        }
        // Genera un nome unico per il file
        $newFileName = uniqid('img_', true) . '.' . $imageFileType;
        $target_file = $target_dir . $newFileName;

        // Prova a spostare il file caricato nella directory di destinazione
        if (move_uploaded_file($_FILES["file"]["tmp_name"], $target_file)) {
            echo 'http://' . $_SERVER['HTTP_HOST'] . '/uploads/news/tmp/' . basename($target_file);
        } else {
            echo 'Errore nel caricamento!';
        }
    }
} else {
    echo 'Nessun file caricato o errore nel caricamento del file.';
}
?>