<?php
$videoDir = __DIR__; // Directory corrente
$descriptionFile = $videoDir . '/descriptions.txt'; // File di descrizione

// Funzione per ottenere le descrizioni con la cartella
function getDescriptions($filePath) {
    $descriptions = [];
    if (file_exists($filePath)) {
        $lines = file($filePath, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
        foreach ($lines as $line) {
            list($file, $description) = explode('=', $line, 2);
            $descriptions[trim($file)] = trim($description);
        }
    }
    return $descriptions;
}

$descriptions = getDescriptions($descriptionFile);

// Funzione per formattare la data
function formatDate($timestamp, $fmt) {
    return $fmt->format(new DateTime("@$timestamp"));
}

// Elenco delle sottocartelle
$subdirs = array_filter(glob($videoDir . '/*'), 'is_dir');

// Verifica se è selezionata una sottocartella
$currentDir = isset($_GET['folder']) ? $_GET['folder'] : '';
$videoDir = !empty($currentDir) ? $videoDir . '/' . $currentDir : $videoDir;
$files = glob($videoDir . '/*.mp4'); // Filtra solo i file .mp4

usort($files, function($a, $b) {
    return filemtime($b) - filemtime($a);
});

// Imposta la localizzazione in italiano
$locale = 'it_IT';
$fmt = new IntlDateFormatter($locale, IntlDateFormatter::FULL, IntlDateFormatter::SHORT, 'Europe/Rome', IntlDateFormatter::GREGORIAN);

$videosPerPage = 10;
$totalVideos = count($files);
$totalPages = ceil($totalVideos / $videosPerPage);

// Ottiene la pagina corrente
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$startIndex = ($page - 1) * $videosPerPage;
$filesOnPage = array_slice($files, $startIndex, $videosPerPage);
?>

<!DOCTYPE html>
<html lang="it">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Video Recenti</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f9f9f9;
            color: #333;
            margin: 0;
            padding: 20px;
        }
        h1 {
            font-size: 24px;
            margin-bottom: 20px;
        }
        .menu {
            margin-bottom: 20px;
        }
        .menu a {
            margin-right: 15px;
            text-decoration: none;
            color: #007BFF;
        }
        .menu a:hover {
            text-decoration: underline;
        }
        .video-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
            gap: 20px;
        }
        .video-item {
            background-color: white;
            padding: 10px;
            border-radius: 5px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
            text-align: center;
        }
        video {
            width: 100%;
            height: auto;
            border-radius: 5px;
            margin-bottom: 10px;
            background-color: #000;
        }
        .pagination {
            margin-top: 20px;
            text-align: center;
        }
        .pagination a {
            margin: 0 5px;
            text-decoration: none;
            color: #007BFF;
        }
        .pagination a:hover {
            text-decoration: underline;
        }
    </style>
</head>
<body>
   <h1>Video Archivio</h1>

<!-- Menu per le sottocartelle -->
<div class="menu">
    <a href="index.php">Video Recenti</a>
    <?php foreach ($subdirs as $dir): ?>
        <a href="?folder=<?php echo basename($dir); ?>"><?php echo ucfirst(basename($dir)); ?></a>
    <?php endforeach; ?>
</div>

<?php
// Ordina i file in base alla data di modifica
usort($filesOnPage, function($a, $b) {
    return filemtime($b) - filemtime($a); // Ordine decrescente
});
?>

<div class="video-grid">
    <?php foreach ($filesOnPage as $file): ?>
        <?php
        $filename = basename($file);
        $filetime = filemtime($file);
        $formattedDate = formatDate($filetime, $fmt);
        
        // Prepara la chiave per cercare la descrizione con il nome della cartella
        $key = (!empty($currentDir) ? $currentDir . '/' : '') . $filename;
        $description = isset($descriptions[$key]) ? $descriptions[$key] : $formattedDate;
        ?>
        <div class="video-item">
            <video controls>
                <source src="<?php echo (isset($_GET['folder']) ? $_GET['folder'] . '/' : '') . $filename; ?>" type="video/mp4">
                Il tuo browser non supporta il tag video.
            </video>
            <p><?php echo $description; ?></p>
        </div>
    <?php endforeach; ?>
</div>


    <!-- Paginazione -->
    <div class="pagination">
        <?php for ($i = 1; $i <= $totalPages; $i++): ?>
            <a href="?page=<?php echo $i; ?><?php echo isset($_GET['folder']) ? '&folder=' . $_GET['folder'] : ''; ?>"><?php echo $i; ?></a>
        <?php endfor; ?>
    </div>
</body>
</html>
