<?php
// Connessione al database
try {
    $pdo = new PDO(DB_DRIVER . ":host=" . DB_SERVER . ";dbname=" . DB_DATABASE, DB_USER, DB_PASS);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Errore connessione database: " . htmlspecialchars($e->getMessage()));
}

// Recupera certificati scaduti

$stmtExpired = $pdo->prepare("

    SELECT u.fname AS fname, u.lname AS lname, u.email, c.expiry_date, c.file_path, c.nome, c.cognome, c.userid

    FROM Certificati c

    INNER JOIN users u ON c.userid = u.id

    WHERE c.expiry_date < CURDATE()

    AND (

        (c.nome = u.fname AND c.cognome = u.lname) OR

        (c.nome <> u.fname OR c.cognome <> u.lname AND c.id IN (

            SELECT MAX(c2.id)

            FROM Certificati c2

            WHERE c2.userid = u.id

            AND (c2.nome <> u.fname OR c2.cognome <> u.lname)

            GROUP BY c2.nome, c2.cognome

        ))

    )

");

$stmtExpired->execute();

$certificatiScaduti = $stmtExpired->fetchAll(PDO::FETCH_ASSOC);









// Recupera utenti senza certificati
$stmtNoCert = $pdo->prepare("
    SELECT u.fname AS nome, u.lname AS cognome, u.email
    FROM users u
    LEFT JOIN Certificati c ON u.id = c.userid
    WHERE c.id IS NULL
");
$stmtNoCert->execute();
$utentiSenzaCertificato = $stmtNoCert->fetchAll(PDO::FETCH_ASSOC);

// Funzione per inviare email di sollecito
function sendCertEmails($data, $type) {
    if (empty($data)) return;

    $core = App::Core();
    $mailer = Mailer::sendMail();
    $mailer->setFrom($core->site_email, $core->company);
    $mailer->isHTML(false);

    foreach ($data as $row) {
        $nome = isset($row['nome']) ? htmlspecialchars($row['nome']) : "Utente";
        $cognome = isset($row['cognome']) ? htmlspecialchars($row['cognome']) : "";
        $email = isset($row['email']) ? $row['email'] : "";

        if ($type === 'expired') {
            $mailer->Subject = "Sollecito certificato medico scaduto";
            $body = "Gentile {$nome},\n\nIl tuo certificato medico è scaduto. Ti invitiamo a rinnovarlo al più presto.\n\nGrazie.\n\n";
        } else {
            $mailer->Subject = "Richiesta caricamento certificato medico";
            $body = "Gentile {$nome},\n\nNon risulta alcun certificato medico associato alla tua iscrizione. Ti invitiamo a caricarlo al più presto.\n\nGrazie.\n\n";
        }

        $emailBody = $body . "Nome: {$nome}, Cognome: {$cognome}\nEmail: {$email}\n";
        $mailer->Body = $emailBody;
        $mailer->addAddress($email, "{$nome} {$cognome}");

        try {
            $mailer->send();
        } catch (Exception $e) {
            error_log("Errore email a {$email}: " . $e->getMessage());
        }
        $mailer->clearAddresses();
    }
}

// Controlla se è stato inviato il form
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['send_cert_expired'])) {
        sendCertEmails($certificatiScaduti, 'expired');
    } elseif (isset($_POST['send_cert_missing'])) {
        sendCertEmails($utentiSenzaCertificato, 'missing');
    }

    // Ricarica la pagina per evitare problemi con AJAX
header("Location: /admin/certificati/");
    exit;
}
?>

<!DOCTYPE html>
<html lang="it">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gestione Certificati</title>
    <style>
        table { width: 100%; border-collapse: collapse; margin-bottom: 20px; }
        th, td { border: 1px solid #ccc; padding: 8px; text-align: left; }
        th { background-color: #f4f4f4; }
    </style>
</head>
<body>
    <h1>Scarica Certificati</h1>
    <p></p>
    <form action="../../uploads/certificati/scarica_certificati.php" method="GET">
        <label for="anno">Seleziona Anno:</label>
        <select name="anno" id="anno">
            <?php
            $currentYear = date("Y");
            $fatturePath = dirname(__DIR__, 2) . '/uploads/certificati';
            $anni = array_filter(glob($fatturePath . '/*'), 'is_dir');
            foreach ($anni as $annoPath) {
                $anno = basename($annoPath);
                echo "<option value=\"$anno\"" . ($anno == $currentYear ? " selected" : "") . ">$anno</option>";
            }
            ?>
        </select>
        
        <label for="mese">Seleziona Mese:</label>
        <select name="mese" id="mese">
            <?php
            $months = [
                "01" => "Gennaio", "02" => "Febbraio", "03" => "Marzo", "04" => "Aprile",
                "05" => "Maggio", "06" => "Giugno", "07" => "Luglio", "08" => "Agosto",
                "09" => "Settembre", "10" => "Ottobre", "11" => "Novembre", "12" => "Dicembre"
            ];
            $currentMonth = date("m");
            foreach ($months as $month => $monthName) {
                echo "<option value=\"$month\"" . ($month == $currentMonth ? " selected" : "") . ">$monthName</option>";
            }
            ?>
        </select>
        
        <button type="submit">Scarica Certificati</button>
    </form>
    
<p><br><br></p>


  <h2>Certificati Scaduti</h2>

<p><br><br></p>

<form method="post">

    <button type="submit" name="send_cert_expired">Manda email di sollecito per certificati scaduti</button>

</form>

<br>

<table>

    <thead>

        <tr>

            <th>Nome</th>

            <th>Cognome</th>

            <th>Email</th>

            <th>Data Scadenza</th>

            <th>Certificato</th>

        </tr>

    </thead>

    <tbody>

        <?php foreach ($certificatiScaduti as $certificato): ?>

            <tr>

                <td><?= htmlspecialchars($certificato['nome']); ?></td>

                <td>

                    <?= htmlspecialchars($certificato['cognome']); ?>

                    <?php 

                    // Controlla se il certificato appartiene all'utente loggato

                    if ($certificato['nome'] !== $certificato['fname'] || $certificato['cognome'] !== $certificato['lname']): ?>

                        (figlio/a di <?= htmlspecialchars($certificato['fname'] . ' ' . $certificato['lname']); ?>)

                    <?php endif; ?>

                </td>

                <td><?= htmlspecialchars($certificato['email']); ?></td>

                <td><?= htmlspecialchars($certificato['expiry_date']); ?></td>

                <td>

                    <a href="../../uploads/certificati/<?= htmlspecialchars($certificato['file_path']); ?>" target="_blank">Visualizza</a>

                </td>

            </tr>

        <?php endforeach; ?>

        <?php if (empty($certificatiScaduti)): ?>

            <tr><td colspan="5">Nessun certificato scaduto.</td></tr>

        <?php endif; ?>

    </tbody>

</table>




<p><br><br></p>


    <h2>Utenti senza Certificato</h2>
    <p><br><br></p>
    <form method="post">
        <button type="submit" name="send_cert_missing">Manda email di sollecito per caricare certificato</button>
    </form><br>
    <table>
        <thead>
            <tr>
                <th>Nome</th>
                <th>Cognome</th>
                <th>Email</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($utentiSenzaCertificato as $utente): ?>
                <tr>
                    <td><?= htmlspecialchars($utente['nome']); ?></td>
                    <td><?= htmlspecialchars($utente['cognome']); ?></td>
                    <td><?= htmlspecialchars($utente['email']); ?></td>
                </tr>
            <?php endforeach; ?>
            <?php if (empty($utentiSenzaCertificato)): ?>
                <tr><td colspan="3">Tutti gli utenti hanno almeno un certificato.</td></tr>
            <?php endif; ?>
        </tbody>
    </table>
</body>
</html>