<!-- /view/admin/conteggi.tpl.php -->


<h1>Elenco degli utenti con ore lavorate</h1>
<br><br>

<ul>
    <?php
    // Connessione al database usando le costanti
    try {
        $pdo = new PDO(DB_DRIVER . ":host=" . DB_SERVER . ";dbname=" . DB_DATABASE, DB_USER, DB_PASS);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        // Query per recuperare gli utenti con ore lavorate
        $sql = "SELECT users.fname, users.lname, users.id as user_id 
                FROM users
                JOIN OreLavoro ON users.id = OreLavoro.account_id
                GROUP BY users.id";

        // Esegui la query
        $stmt = $pdo->query($sql);

        // Recupera i risultati come array di oggetti
        $utenti = $stmt->fetchAll(PDO::FETCH_OBJ);

    } catch (PDOException $e) {
        die("Errore connessione database: " . $e->getMessage());
    }
    
    // Verifica che ci siano utenti
    if (isset($utenti) && !empty($utenti)) {
        // Itera sugli utenti
        foreach ($utenti as $utente):
    ?>
        <li>
            <a href="/admin/conteggi/user_details/<?php echo $utente->user_id; ?>">
                <?php echo htmlspecialchars($utente->fname) . ' ' . htmlspecialchars($utente->lname); ?>
            </a>
        </li>
    <?php
        endforeach;
    } else {
        echo "<p>Nessun utente trovato.</p>";
    }
    ?>
</ul>
