<?php
// Imposta l'header per una risposta JSON
header('Content-Type: application/json');

try {
    // Configurazione: nome del file ZIP e percorso di destinazione
    $zipFileName = 'certificati_' . date('Y_m_d_H_i_s') . '.zip';
    $zipFilePath = __DIR__ . '/zips/' . $zipFileName;

    // Crea la directory per gli ZIP se non esiste
    if (!is_dir(__DIR__ . '/zips')) {
        mkdir(__DIR__ . '/zips', 0777, true);
    }

    // Verifica che siano stati inviati i file da includere
    if (empty($_POST['files']) || !is_array($_POST['files'])) {
        throw new Exception('Nessun file specificato per la compressione.');
    }

    // Crea un nuovo archivio ZIP
    $zip = new ZipArchive();
    if ($zip->open($zipFilePath, ZipArchive::CREATE) !== true) {
        throw new Exception('Impossibile creare il file ZIP.');
    }

    // Aggiungi i file allo ZIP
    foreach ($_POST['files'] as $filePath) {
        // Costruisce il percorso assoluto del file
        $fullPath = __DIR__ . '/' . $filePath;

        // Verifica che il file esista
        if (!file_exists($fullPath)) {
            throw new Exception("Il file $filePath non esiste.");
        }

        // Aggiungi il file allo ZIP
        $relativePath = basename($filePath); // Mantieni solo il nome del file
        if (!$zip->addFile($fullPath, $relativePath)) {
            throw new Exception("Impossibile aggiungere il file $filePath allo ZIP.");
        }
    }

    // Chiudi l'archivio ZIP
    $zip->close();

    // Restituisci il percorso del file ZIP come risposta JSON
    echo json_encode([
        'success' => true,
        'url' => 'zips/' . $zipFileName
    ]);
} catch (Exception $e) {
    // Gestione degli errori
    http_response_code(400); // Imposta un codice di errore HTTP
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
