
<h1>INSERISCI UN PAGAMENTO MANUALE</h1>
<br><br>

<!-- Campo di ricerca -->
<label for="search">Cerca per cognome:</label>
<input type="text" id="search" placeholder="Digita il cognome">
<br><br>

<!-- Lista utenti dinamica -->
<label for="user-dropdown">Utenti trovati:</label>
<select id="user-dropdown">
    <option value="" disabled selected>Inizia a digitare per cercare gli utenti...</option>
</select>

<script>
    document.getElementById('search').addEventListener('input', function () {
        const searchValue = this.value.trim();

        // Effettua una richiesta Ajax solo se il campo non è vuoto
        if (searchValue.length > 0) {
            fetch(`/admin/pagamenti/search?lname=${encodeURIComponent(searchValue)}`)
                .then(response => response.json())
                .then(data => {
                    const userDropdown = document.getElementById('user-dropdown');
                    userDropdown.innerHTML = ''; // Svuota la lista precedente
                    
                    if (data.length > 0) {
                        // Aggiungi un'opzione predefinita
                        userDropdown.innerHTML = '<option value="" disabled selected>Seleziona un utente...</option>';
                        
                        // Aggiungi gli utenti trovati
                        data.forEach(user => {
                            const option = document.createElement('option');
                            option.value = user.id;
                            option.textContent = `${user.fname} ${user.lname}`;
                            userDropdown.appendChild(option);
                        });
                    } else {
                        // Nessun risultato trovato
                        userDropdown.innerHTML = '<option value="" disabled selected>Nessun utente trovato</option>';
                    }
                })
                .catch(error => console.error('Errore nella ricerca:', error));
        } else {
            // Mostra il messaggio predefinito se il campo è vuoto
            document.getElementById('user-dropdown').innerHTML = '<option value="" disabled selected>Inizia a digitare per cercare gli utenti...</option>';
        }
    });
</script>
