<?php
// Recupera l'ID utente dalla URL (dallo segmento 3 della route)
$user_id = isset($GLOBALS['router']->segments[3]) ? (int)$GLOBALS['router']->segments[3] : 0;

// Recupera il mese e l'anno dalla query string, con valori di default
$month = isset($_GET['month']) ? (int)$_GET['month'] : date('m');  // Default mese corrente
$year = isset($_GET['year']) ? (int)$_GET['year'] : date('Y');  // Default anno corrente

// Array con i nomi dei mesi in italiano
$mesi_italiano = [
    1 => 'Gennaio', 2 => 'Febbraio', 3 => 'Marzo', 4 => 'Aprile', 5 => 'Maggio', 6 => 'Giugno',
    7 => 'Luglio', 8 => 'Agosto', 9 => 'Settembre', 10 => 'Ottobre', 11 => 'Novembre', 12 => 'Dicembre'
];

// Correzione per garantire che il mese venga sempre trattato come numero intero
$month = intval($month); // Converte il mese in numero intero

// Usando il mese come intero per accedere all'array
$nome_mese = $mesi_italiano[$month];

// Connessione al database usando le costanti
try {
    $pdo = new PDO(DB_DRIVER . ":host=" . DB_SERVER . ";dbname=" . DB_DATABASE, DB_USER, DB_PASS);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Verifica che l'ID dell'utente sia valido
    if ($user_id > 0) {
        // Query per recuperare nome e cognome dell'utente
        $sql_user = "SELECT fname, lname FROM users WHERE id = :user_id";
        $stmt_user = $pdo->prepare($sql_user);
        $stmt_user->bindParam(':user_id', $user_id, PDO::PARAM_INT);
        $stmt_user->execute();

        // Recupera il nome e il cognome dell'utente
        $user_data = $stmt_user->fetch(PDO::FETCH_OBJ);

        // Se l'utente esiste
        if ($user_data) {
            $user_name = $user_data->fname . ' ' . $user_data->lname;
            echo "<h1>Dettagli ore lavorate per l'utente: $user_name</h1>";

            // Query per recuperare le ore lavorate dell'utente nel mese corrente
            $sql = "SELECT * FROM OreLavoro WHERE account_id = :user_id AND MONTH(data_lavoro) = :month AND YEAR(data_lavoro) = :year";
            $stmt = $pdo->prepare($sql);
            $stmt->bindParam(':user_id', $user_id, PDO::PARAM_INT);
            $stmt->bindParam(':month', $month, PDO::PARAM_INT);
            $stmt->bindParam(':year', $year, PDO::PARAM_INT);
            $stmt->execute();

            // Recupera le ore lavorate
            $ore_lavorate = $stmt->fetchAll(PDO::FETCH_OBJ);

            // Se ci sono ore lavorate, visualizza i dettagli
            if ($ore_lavorate) {
                echo "<table border='1' style='width: 100%;'>
                        <tr>
                            <th style='text-align: left;'>Data</th>
                            <th style='text-align: left;'>Ore lavorate</th>
                        </tr>";

                foreach ($ore_lavorate as $ore) {
                    echo "<tr>
                            <td style='text-align: left;'>" . date('d-m-Y', strtotime($ore->data_lavoro)) . "</td>
                            <td style='text-align: left;'>" . $ore->ore_lavorate . "</td>
                          </tr>";
                }

                echo "</table>";

                // Somma delle ore lavorate
                $sql_sum = "SELECT SUM(ore_lavorate) AS total_ore FROM OreLavoro WHERE account_id = :user_id AND MONTH(data_lavoro) = :month AND YEAR(data_lavoro) = :year";
                $stmt_sum = $pdo->prepare($sql_sum);
                $stmt_sum->bindParam(':user_id', $user_id, PDO::PARAM_INT);
                $stmt_sum->bindParam(':month', $month, PDO::PARAM_INT);
                $stmt_sum->bindParam(':year', $year, PDO::PARAM_INT);
                $stmt_sum->execute();
                $total_ore = $stmt_sum->fetch(PDO::FETCH_OBJ)->total_ore;

                echo "<p>Ore totali lavorate nel mese: $total_ore</p>";
            } else {
                echo "<p>Nessuna ora lavorata trovata per il mese " . $mesi_italiano[$month] . " $year.</p>";
            }

            // Visualizza selezione mese e anno
            echo "<form method='GET' action='/admin/conteggi/user_details/$user_id'>
                    <label for='month'>Seleziona mese:</label>
                    <select name='month' id='month'>
                        <option value='1' " . ($month == 1 ? 'selected' : '') . ">Gennaio</option>
                        <option value='2' " . ($month == 2 ? 'selected' : '') . ">Febbraio</option>
                        <option value='3' " . ($month == 3 ? 'selected' : '') . ">Marzo</option>
                        <option value='4' " . ($month == 4 ? 'selected' : '') . ">Aprile</option>
                        <option value='5' " . ($month == 5 ? 'selected' : '') . ">Maggio</option>
                        <option value='6' " . ($month == 6 ? 'selected' : '') . ">Giugno</option>
                        <option value='7' " . ($month == 7 ? 'selected' : '') . ">Luglio</option>
                        <option value='8' " . ($month == 8 ? 'selected' : '') . ">Agosto</option>
                        <option value='9' " . ($month == 9 ? 'selected' : '') . ">Settembre</option>
                        <option value='10' " . ($month == 10 ? 'selected' : '') . ">Ottobre</option>
                        <option value='11' " . ($month == 11 ? 'selected' : '') . ">Novembre</option>
                        <option value='12' " . ($month == 12 ? 'selected' : '') . ">Dicembre</option>
                    </select>
                    
                    <label for='year'>Seleziona anno:</label>
                    <select name='year' id='year'>
                        <option value='" . date('Y') . "' " . ($year == date('Y') ? 'selected' : '') . ">" . date('Y') . "</option>
                        <option value='" . (date('Y') + 1) . "' " . ($year == (date('Y') + 1) ? 'selected' : '') . ">" . (date('Y') + 1) . "</option>
                    </select>
                    
                    <input type='submit' value='Vai'>
                  </form>";

            // Stampa mese e anno correnti per il debug
            echo "<p>Mese corrente: " . $mesi_italiano[$month] . " $year</p>";

        } else {
            echo "<p>ID utente non valido.</p>";
        }
    } else {
        echo "<p>ID utente non valido.</p>";
    }
} catch (PDOException $e) {
    die("Errore connessione al database: " . $e->getMessage());
}
?>
