<?php
if (!defined('_WOJO')) {
    die('Direct access to this location is not allowed.');
}

// Imposta la lingua italiana per la localizzazione
setlocale(LC_TIME, 'it_IT.UTF-8');

// Connessione al database
try {
    $pdo = new PDO(DB_DRIVER . ":host=" . DB_SERVER . ";dbname=" . DB_DATABASE, DB_USER, DB_PASS);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Errore connessione database: " . $e->getMessage());
}

// Recupera l'account_id dell'utente loggato tramite il sistema di autenticazione
$accountId = App::Auth()->uid;

if (!$accountId) {
    die("Utente non loggato.");
}

// Recupera i certificati dell'utente
$stmt = $pdo->prepare("SELECT * FROM Certificati WHERE userid = :userid ORDER BY expiry_date DESC");
$stmt->execute([':userid' => $accountId]);
$certificati = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Verifica e aggiorna 'nome' e 'cognome' nei certificati
foreach ($certificati as $certificato) {
    if ($certificato['nome'] === '0' && $certificato['cognome'] === '0') {
        // Recupera nome e cognome dalla tabella 'users'
        $userStmt = $pdo->prepare("SELECT fname, lname FROM users WHERE id = :userid");
        $userStmt->execute([':userid' => $accountId]);
        $user = $userStmt->fetch(PDO::FETCH_ASSOC);

        if ($user) {
            $nome = $user['fname'];
            $cognome = $user['lname'];

            // Aggiorna la tabella 'Certificati'
            $updateStmt = $pdo->prepare("
                UPDATE Certificati
                SET nome = :nome, cognome = :cognome
                WHERE id = :id
            ");
            $updateStmt->execute([
                ':nome' => $nome,
                ':cognome' => $cognome,
                ':id' => $certificato['id']
            ]);
        }
    }
}

// Gestione dell'upload del certificato
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['upload'])) {
    $baseUploadDir = BASEPATH . 'uploads/certificati/';

    // Ottieni anno e mese correnti
    $currentYear = date('Y');
    $currentMonth = date('m');

    // Costruisci il percorso delle directory dinamiche
    $uploadDir = $baseUploadDir . $currentYear . '/' . $currentMonth . '/';

    // Creazione delle directory se non esistono
    if (!is_dir($uploadDir)) {
        mkdir($uploadDir, 0755, true);
    }

    $file = $_FILES['file'] ?? null;
    $expiryDate = $_POST['expiry_date'] ?? null;

    if ($file && $expiryDate) {
        // Genera un nome univoco per il file
        $fileName = time() . '_' . basename($file['name']);
        $filePath = $uploadDir . $fileName;

        if (move_uploaded_file($file['tmp_name'], $filePath)) {
            // Inserisce il certificato nel database con il percorso aggiornato
            $stmt = $pdo->prepare("
                INSERT INTO Certificati (userid, file_path, expiry_date)
                VALUES (:userid, :file_path, :expiry_date)
            ");
            $stmt->execute([
                ':userid' => $accountId,
                ':file_path' => $currentYear . '/' . $currentMonth . '/' . $fileName,
                ':expiry_date' => $expiryDate,
            ]);

            // Modifica nome e cognome direttamente dopo l'inserimento
            $stmtUpdate = $pdo->prepare("
                UPDATE Certificati
                SET nome = :nome, cognome = :cognome
                WHERE userid = :userid AND nome = '0' AND cognome = '0'
            ");
            $userStmt = $pdo->prepare("SELECT fname, lname FROM users WHERE id = :userid");
            $userStmt->execute([':userid' => $accountId]);
            $user = $userStmt->fetch(PDO::FETCH_ASSOC);
            if ($user) {
                $stmtUpdate->execute([
                    ':nome' => $user['fname'],
                    ':cognome' => $user['lname'],
                    ':userid' => $accountId
                ]);
            }

            echo "<p>Certificato caricato e aggiornato correttamente.</p>";

            // Richiama dinamicamente la tabella dei certificati
            // Non facciamo il redirect, ma carichiamo subito i certificati dopo l'inserimento
            $stmt = $pdo->prepare("SELECT * FROM Certificati WHERE userid = :userid ORDER BY expiry_date DESC");
            $stmt->execute([':userid' => $accountId]);
            $certificati = $stmt->fetchAll(PDO::FETCH_ASSOC);
        }
    } else {
        echo "<p>Compila tutti i campi.</p>";
    }
}

?>

<!DOCTYPE html>
<html lang="it">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gestione Certificati</title>
</head>
<body>
    <h1>Gestione Certificati</h1>

    <!-- Form per l'upload dei certificati -->
    <form method="POST" enctype="multipart/form-data">
        <label for="expiry_date">Data di scadenza:</label>
        <input type="date" id="expiry_date" name="expiry_date" required><br><br>
        <label for="file">Carica certificato:</label>
        <input type="file" id="file" name="file" required><br><br>
        <button type="submit" name="upload">Carica</button><br><br>
    </form>
    <br><br>

    <h2>Certificati Caricati</h2>
<?php if (!empty($certificati)): ?>
    <table border="1">
        <thead>
            <tr>
                <th>Numero</th>
                <th>File</th>
                <th>Data di Scadenza</th>
                <th>Nome</th>
                <th>Cognome</th>
            </tr>
        </thead>
        <tbody>
            <?php 
            // Ordinamento dei certificati per ID in ordine decrescente
            usort($certificati, function($a, $b) {
                return $b['id'] - $a['id']; // Confronto decrescente sugli ID
            });

            foreach ($certificati as $certificato): ?>
                <tr>
                    <td><?= htmlspecialchars($certificato['id']) ?></td>
                    <td>
                        <a href="<?= SITEURL . '/uploads/certificati/' . htmlspecialchars($certificato['file_path']) ?>" target="_blank">
                            <?= htmlspecialchars($certificato['file_path']) ?>
                        </a>
                    </td>
                    <td><?= htmlspecialchars($certificato['expiry_date']) ?></td>
                    <td><?= htmlspecialchars($certificato['nome']) ?></td>
                    <td><?= htmlspecialchars($certificato['cognome']) ?></td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
<?php else: ?>
    <p>Nessun certificato caricato.</p>
<?php endif; ?>

    <?php
    // Gestione eliminazione certificati
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['delete'])) {
        $deleteId = $_POST['delete_id'] ?? null;

        if ($deleteId) {
            $stmt = $pdo->prepare("SELECT file_path FROM Certificati WHERE id = :id AND userid = :userid");
            $stmt->execute([':id' => $deleteId, ':userid' => $accountId]);
            $certificato = $stmt->fetch(PDO::FETCH_ASSOC);

            if ($certificato) {
                $filePath = $baseUploadDir . $certificato['file_path'];

                if (file_exists($filePath)) {
                    unlink($filePath);
                }

                $stmt = $pdo->prepare("DELETE FROM Certificati WHERE id = :id AND userid = :userid");
                $stmt->execute([':id' => $deleteId, ':userid' => $accountId]);
                echo "<p>Certificato eliminato con successo.</p>";
                header("Refresh:0");
            }
        }
    }
    ?>
</body>
</html>
