<?php
if (!defined('_WOJO')) {
    die('Direct access to this location is not allowed.');
}

// Imposta la lingua italiana per la localizzazione
setlocale(LC_TIME, 'it_IT.UTF-8');

// Connessione al database
try {
    $pdo = new PDO(DB_DRIVER . ":host=" . DB_SERVER . ";dbname=" . DB_DATABASE, DB_USER, DB_PASS);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Errore connessione database: " . $e->getMessage());
}

// Recupera l'account_id dell'utente loggato tramite il sistema di autenticazione
$accountId = App::Auth()->uid;

if (!$accountId) {
    die("Utente non loggato.");
}

// Recupera i certificati dell'utente
$stmt = $pdo->prepare("SELECT * FROM Certificati WHERE userid = :userid ORDER BY expiry_date DESC");
$stmt->execute([':userid' => $accountId]);
$certificati = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Recupera nome e cognome dalla tabella 'users'
$userStmt = $pdo->prepare("SELECT fname, lname FROM users WHERE id = :userid");
$userStmt->execute([':userid' => $accountId]);
$user = $userStmt->fetch(PDO::FETCH_ASSOC);

if ($user) {
    $nome = $user['fname'];
    $cognome = $user['lname'];

    // Verifica e aggiorna 'nome' e 'cognome' nei certificati
    foreach ($certificati as $certificato) {
        if ($certificato['nome'] === null && $certificato['cognome'] === null) {
            // Aggiorna la tabella 'Certificati'
            $updateStmt = $pdo->prepare("
                UPDATE Certificati
                SET nome = :nome, cognome = :cognome
                WHERE id = :id
            ");
            $updateStmt->execute([
                ':nome' => $nome,
                ':cognome' => $cognome,
                ':id' => $certificato['id']
            ]);
        }
    }
}

// Gestione dell'upload del certificato

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['upload'])) {

    $baseUploadDir = BASEPATH . 'uploads/certificati/';



    // Ottieni anno e mese correnti

    $currentYear = date('Y');

    $currentMonth = date('m');



    // Costruisci il percorso delle directory dinamiche

    $uploadDir = $baseUploadDir . $currentYear . '/' . $currentMonth . '/';



    // Creazione delle directory se non esistono

    if (!is_dir($uploadDir)) {

        mkdir($uploadDir, 0755, true);

    }



    $file = $_FILES['file'] ?? null;

    $expiryDate = $_POST['expiry_date'] ?? null;

    $childFirstName = $_POST['child_first_name'] ?? null;

    $childLastName = $_POST['child_last_name'] ?? null;



    // Set NULL if first name or last name is not provided

    $childFirstName = !empty($childFirstName) ? $childFirstName : null;

    $childLastName = !empty($childLastName) ? $childLastName : null;



    if ($file && $expiryDate) {

        // Rimuovi spazi dal nome del file

        $originalFileName = basename($file['name']);

        $sanitizedFileName = str_replace(' ', '_', $originalFileName); // Sostituisce gli spazi con '_'

        

        // Genera un nome di file unico

        $fileName = time() . '_' . $sanitizedFileName;

        $filePath = $uploadDir . $fileName;



        // Definisci le estensioni consentite

        $allowedExtensions = ['pdf', 'jpg', 'jpeg', 'png', 'gif', 'doc', 'docx', 'txt', 'rtf'];



        // Ottieni l'estensione del file caricato

        $fileExtension = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));



        // Verifica se l'estensione è consentita

        if (in_array($fileExtension, $allowedExtensions)) {

            // Controlla la dimensione massima del file (3 MB)

            $maxFileSize = 3 * 1024 * 1024; // 3 MB in byte

            if ($file['size'] <= $maxFileSize) {

                if (move_uploaded_file($file['tmp_name'], $filePath)) {

                    // Insert certificate into database with updated path

                    $stmt = $pdo->prepare("

                        INSERT INTO Certificati (userid, file_path, expiry_date, nome, cognome)

                        VALUES (:userid, :file_path, :expiry_date, :nome, :cognome)

                    ");

                    $stmt->execute([

                        ':userid' => $accountId,

                        ':file_path' => $currentYear . '/' . $currentMonth . '/' . $fileName,

                        ':expiry_date' => $expiryDate,

                        ':nome' => $childFirstName,

                        ':cognome' => $childLastName

                    ]);



                    echo "<p>Certificato caricato e aggiornato correttamente.</p>";



                    // Reload certificates

                    $stmt = $pdo->prepare("SELECT * FROM Certificati WHERE userid = :userid ORDER BY expiry_date DESC");

                    $stmt->execute([':userid' => $accountId]);

                    $certificati = $stmt->fetchAll(PDO::FETCH_ASSOC);

                }

            } else {

                echo "<p>Il file è troppo grande. La dimensione massima consentita è di 3 MB.</p>";

            }

        } else {

            echo "<p>Tipo di file non consentito. Puoi caricare solo file con le seguenti estensioni: " . implode(', ', $allowedExtensions) . ".</p>";

        }

    } else {

        echo "<p>Compila tutti i campi obbligatori.</p>";

    }

}





?>

<!DOCTYPE html>
<html lang="it">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gestione Certificati</title>
</head>
<body>
    <p></p>
    <h1>Gestione Certificati</h1>
    
    <p></p>

    <!-- Form per l'upload dei certificati -->
<form method="POST" enctype="multipart/form-data">
    <label for="expiry_date">Data di scadenza:</label>
    <input type="date" id="expiry_date" name="expiry_date" required><br><br>

    <label for="file">Seleziona certificato dal tuo dispositivo, massimo 3 MB:</label><br>
    <input type="file" id="file" name="file" required><br><br>

    SE CARICHI <b>PER UN FIGLIO</b> INSERISCI NOME E COGNOME DEL FIGLIO <br> 
    SE CARICHI PER TE STESSO <b>NON INSERIRE</b> NESSUN NOME<br><br>

    <label for="child_first_name">Nome figlio:</label>
    <input type="text" id="child_first_name" name="child_first_name"><br><br>

    <label for="child_last_name">Cognome figlio:</label>
    <input type="text" id="child_last_name" name="child_last_name"><br><br>

    <button type="submit" name="upload">SALVA CERTIFICATO</button><br><br>
</form>

<script>
    document.getElementById('expiry_date').addEventListener('change', function () {
        let inputDate = new Date(this.value);
        let today = new Date();
        let maxDate = new Date();
        maxDate.setFullYear(today.getFullYear() + 1); // Data massima consentita (oggi + 1 anno)

        if (inputDate > maxDate) {
            alert("La data di scadenza non può essere superiore a un anno da oggi.");
            this.value = ""; // Resetta il campo
        }
    });
</script>
    <br><br>

    <h2>Certificati Caricati</h2>
    <?php if (!empty($certificati)): ?>
    <table border="1">
        <thead>
            <tr>
                <th>Numero</th>
                <th>File</th>
                <th>Data di Scadenza</th>
                <th>Nome</th>
                <th>Cognome</th>
                <th>Azioni</th>
            </tr>
        </thead>
        <tbody>
            <?php 
            // Ordinamento dei certificati per ID in ordine decrescente
            usort($certificati, function ($a, $b) {
                return $b['id'] - $a['id'];
            });

            foreach ($certificati as $certificato): ?>
                <tr>
                    <td><?= htmlspecialchars($certificato['id']) ?></td>
                    <td>
                        <a href="<?= SITEURL . '/uploads/certificati/' . htmlspecialchars($certificato['file_path']) ?>" target="_blank">
                            <?= htmlspecialchars($certificato['file_path']) ?>
                        </a>
                    </td>
                    <td><?= htmlspecialchars($certificato['expiry_date']) ?></td>
                    <td><?= htmlspecialchars($certificato['nome'] ?? 'N/A') ?></td>
                    <td><?= htmlspecialchars($certificato['cognome'] ?? 'N/A') ?></td>
                    <td>
                        <form method="POST">
                            <input type="hidden" name="delete_id" value="<?= htmlspecialchars($certificato['id']) ?>">
                            <button type="submit" name="delete">Elimina</button>
                        </form>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <?php else: ?>
    <p>Nessun certificato caricato.</p>
    <?php endif; ?>
    
   <?php

// Percorso base della directory di caricamento
$baseUploadDir = __DIR__ . '/uploads/certificati/';

// Gestione eliminazione certificati
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['delete'])) {
    $deleteId = $_POST['delete_id'] ?? null;

    if ($deleteId) {
        // Recupera il percorso del file dal database
        $stmt = $pdo->prepare("SELECT file_path FROM Certificati WHERE id = :id AND userid = :userid");
        $stmt->execute([':id' => $deleteId, ':userid' => $accountId]);
        $certificato = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($certificato) {
            // La file_path nel database deve contenere il percorso relativo alla directory di upload
            $filePath = $baseUploadDir . $certificato['file_path'];

            // Elimina il file dal filesystem
            if (file_exists($filePath)) {
                if (unlink($filePath)) {
                    echo "File eliminato con successo.";
                } else {
                    echo "Errore nell'eliminazione del file.";
                }
            } else {
                echo "File non trovato: $filePath";
            }

            // Elimina il record dal database
            $stmt = $pdo->prepare("DELETE FROM Certificati WHERE id = :id AND userid = :userid");
            $stmt->execute([':id' => $deleteId, ':userid' => $accountId]);

            echo "Certificato eliminato dal database con successo.";
            // Ricarica la pagina o fai un redirect per aggiornare la lista dei certificati
            header("Refresh:0"); // Ricarica la pagina
            exit;
        } else {
            echo "Errore: certificato non trovato.";
        }
    } else {
        echo "Errore: ID certificato non valido.";
    }
}
?>


</body>
</html>