<?php
if (!defined('_WOJO')) {
    die('Direct access to this location is not allowed.');
}

// Imposta la lingua italiana per la localizzazione
setlocale(LC_TIME, 'it_IT.UTF-8'); 

// Connessione al database
try {
    $pdo = new PDO(DB_DRIVER . ":host=" . DB_SERVER . ";dbname=" . DB_DATABASE, DB_USER, DB_PASS);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Errore connessione database: " . $e->getMessage());
}

// Recupera l'account_id dell'utente loggato
$accountId = isset($this->data->id) ? $this->data->id : null;
if (!$accountId) {
    die("Utente non loggato.");
}

// Verifica se l'utente è presente in DatiUtenti
$stmt = $pdo->prepare("SELECT * FROM DatiUtenti WHERE account_id = :account_id");
$stmt->execute([':account_id' => $accountId]);
$utente = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$utente) {
    // L'utente non è presente, mostra il messaggio e il pulsante per attivare il servizio
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['attiva_servizio'])) {
       
       // Recupera i dati dell'utente loggato dalla tabella 'users'
$userQuery = $pdo->prepare("SELECT fname, lname, email FROM users WHERE id = :account_id");
$userQuery->execute([':account_id' => $accountId]);
$userData = $userQuery->fetch(PDO::FETCH_ASSOC);

if ($userData) {
    $nomeCompleto = $userData['fname'] . ' ' . $userData['lname'];
    $email = $userData['email'];

    // Inserisce i dati nella tabella DatiUtenti
    $stmt = $pdo->prepare("
        INSERT INTO DatiUtenti (account_id, nome, email, data_inserimento, stato)
        VALUES (:account_id, :nome, :email, NOW(), 'attivo')
    ");
    $stmt->execute([
        ':account_id' => $accountId,
        ':nome' => $nomeCompleto,
        ':email' => $email
    ]);
} else {
    die("Errore: dati utente non trovati.");
}


        // Ricarica la pagina per aggiornare lo stato
        header("Location: " . $_SERVER['REQUEST_URI']);
        exit;
    }

    // Mostra il messaggio e il pulsante per attivare il servizio
    ?>
    <main>
        <div class="padding-vertical">
            <div class="wojo-grid">
                <div class="center-align margin-vertical">
                    <h2>Servizio non attivo</h2>
                    <p>Per utilizzare questa funzionalità, attiva il servizio.</p>
                    <form method="POST" action="">
                        <button type="submit" name="attiva_servizio" class="wojo primary button">Attiva il servizio</button>
                    </form>
                </div>
            </div>
        </div>
    </main>
    <?php
    exit; // Interrompi l'esecuzione del resto del codice
}

// Gestione del mese corrente, precedente e successivo
$month = isset($_GET['month']) ? str_pad((int)$_GET['month'], 2, '0', STR_PAD_LEFT) : date('m');
$year = isset($_GET['year']) ? (int)$_GET['year'] : date('Y');

// Calcolo del primo giorno del mese
$firstDay = "$year-$month-01";

// Ottieni il nome del mese in italiano usando DateTime::format()
$date = new DateTime($firstDay);
$monthName = $date->format('F'); // Nome completo del mese (es. 'January')

// Traduci il nome del mese in italiano
$monthNames = [
    'January' => 'Gennaio',
    'February' => 'Febbraio',
    'March' => 'Marzo',
    'April' => 'Aprile',
    'May' => 'Maggio',
    'June' => 'Giugno',
    'July' => 'Luglio',
    'August' => 'Agosto',
    'September' => 'Settembre',
    'October' => 'Ottobre',
    'November' => 'Novembre',
    'December' => 'Dicembre',
];

$translatedMonthName = $monthNames[$monthName]; // Traduzione del nome del mese

try {
    // Connessione al database
    $pdo = new PDO(DB_DRIVER . ":host=" . DB_SERVER . ";dbname=" . DB_DATABASE, DB_USER, DB_PASS);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Errore connessione database: " . $e->getMessage());
}

// Recupera l'account_id dell'utente loggato
$accountId = isset($this->data->id) ? $this->data->id : null;
if (!$accountId) {
    die("Utente non loggato.");
}

// Calcolo mese precedente e successivo
$prevMonth = date('m', strtotime('-1 month', strtotime($firstDay)));
$prevYear = date('Y', strtotime('-1 month', strtotime($firstDay)));
$nextMonth = date('m', strtotime('+1 month', strtotime($firstDay)));
$nextYear = date('Y', strtotime('+1 month', strtotime($firstDay)));




////////////////////////////////////////////////////////////////////////

// Recupera le ore lavorate dal database
$stmt = $pdo->prepare("SELECT data_lavoro, ore_lavorate FROM OreLavoro WHERE account_id = :account_id AND YEAR(data_lavoro) = :year AND MONTH(data_lavoro) = :month");
$stmt->execute([
    ':account_id' => $accountId,
    ':year' => $year,
    ':month' => $month,
]);

// Debug query
//if ($stmt->rowCount() > 0) {
//    echo "Query success: Data found for $year-$month";  // DEBUG
//} else {
//    echo "No data found for $year-$month";  // DEBUG
//}

$oreLavorateMap = [];
$totalOreLavorate = 0;
while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
    $oreLavorateMap[$row['data_lavoro']] = $row['ore_lavorate'];
    $totalOreLavorate += $row['ore_lavorate'];
}

// Gestione POST per salvare o cancellare
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['salva'])) {
        $giorno = $_POST['salva'];
        $oreLavorateArray = $_POST['ore_lavorate'];
        $oreLavorate = isset($oreLavorateArray[$giorno]) ? (float)$oreLavorateArray[$giorno] : 0;

        // Inserisci o aggiorna le ore lavorate
        $stmt = $pdo->prepare("
            INSERT INTO OreLavoro (account_id, data_lavoro, ore_lavorate)
            VALUES (:account_id, :data_lavoro, :ore_lavorate)
            ON DUPLICATE KEY UPDATE ore_lavorate = :ore_lavorate
        ");
        $stmt->execute([
            ':account_id' => $accountId,
            ':data_lavoro' => $giorno,
            ':ore_lavorate' => $oreLavorate
        ]);
    } elseif (isset($_POST['cancella'])) {
        $giorno = $_POST['cancella'];

        // Cancella le ore lavorate (impostandole a 0)
        $stmt = $pdo->prepare("UPDATE OreLavoro SET ore_lavorate = 0 WHERE account_id = :account_id AND data_lavoro = :data_lavoro");
        $stmt->execute([
            ':account_id' => $accountId,
            ':data_lavoro' => $giorno
        ]);
    }

    // Ricarica la pagina per aggiornare i dati
    header("Location: /dashboard/conteggi/?month=$month&year=$year");   
    exit;
}
?>

<!-- Resto del codice per la visualizzazione -->


<main>
    <div class="padding-vertical">
        <div class="wojo-grid">
            <div class="center-align margin-vertical">
                <h2>Gestione Ore Lavorate</h2><BR>
                <div class="navigation">
                  <a href="/dashboard/conteggi?month=<?php echo $prevMonth; ?>&year=<?php echo $prevYear; ?>" class="wojo small button">← Mese Precedente</a>
<span class="wojo primary label"><?php echo $translatedMonthName . ' ' . date('Y', strtotime($firstDay)); ?></span>
<a href="/dashboard/conteggi?month=<?php echo $nextMonth; ?>&year=<?php echo $nextYear; ?>" class="wojo small button">Mese Successivo →</a>

                </div><BR>
                <form method="POST" action="">
                    <h3>Totale Ore Lavorate: <?php echo $totalOreLavorate; ?> ore</h3>
                    <table class="wojo table">
                        <thead>
                            <tr>
                                <th>Data</th>
                                <th>Ore Lavorate</th>
                                <th>Azioni</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            for ($day = 1; $day <= date('t', strtotime($firstDay)); $day++) {
                                $dataLavoro = "$year-$month-" . str_pad($day, 2, '0', STR_PAD_LEFT);
                                $oreLavorate = isset($oreLavorateMap[$dataLavoro]) ? $oreLavorateMap[$dataLavoro] : 0;
                                ?>
                                <tr>
                                    <td><?php echo date('d/m/Y', strtotime($dataLavoro)); ?></td>
                                    <td>
                                        <input type="number" name="ore_lavorate[<?php echo $dataLavoro; ?>]" step="0.5" min="0" value="<?php echo $oreLavorate; ?>">
                                    </td>
                                    <td>
                                        <button type="submit" name="salva" value="<?php echo $dataLavoro; ?>" class="wojo small primary button">Salva</button>
                                        <button type="submit" name="cancella" value="<?php echo $dataLavoro; ?>" class="wojo small negative button">Cancella</button>
                                    </td>
                                </tr>
                                <?php
                            }
                            ?>
                        </tbody>
                    </table>
                </form>
            </div>
        </div>
    </div>
</main>
