<?php
    /**
     * controller
     *
     * @package Wojo Framework
     * @author wojoscripts.com
     * @copyright 2023
     * @version 5.00: controller.php, v1.00 7/12/2023 10:25 AM Gewa Exp $
     *
     */
    
    use Mpdf\Mpdf;
    use Mpdf\MpdfException;
    
    const _WOJO = true;
    require_once('../../init.php');
    
    $delete = Validator::post('delete');
    $trash = Validator::post('trash');
    $pAction = Validator::post('action');
    $gAction = Validator::get('action');
    $restore = Validator::post('restore');
    $title = Validator::post('title') ? Validator::sanitize($_POST['title']) : null;
    
    
    
    /* == Post Actions == */
    switch ($pAction):
        //Login
        case 'userLogin':
        case 'adminLogin':
            App::Auth()->login($_POST['username'], $_POST['password']);
            break;
            
            // Gestione della pagina "conteggi"
    case 'conteggi':
        if (!App::Auth()->is_User()) {
            exit; // L'utente deve essere autenticato
        }

        // Recupera i parametri del mese e dell'anno dalla query string
        $month = isset($_GET['month']) ? (int)$_GET['month'] : date('m');
        $year = isset($_GET['year']) ? (int)$_GET['year'] : date('Y');

        // Validazione dei parametri
        if ($month < 1 || $month > 12 || $year < 1900 || $year > 2100) {
            die("Parametri non validi.");
        }

        // Caricamento della vista "conteggi"
        $tpl = App::View(BASEPATH . 'view/front/');
        $tpl->template = 'conteggi';
        $tpl->month = $month;
        $tpl->year = $year;

        // Recupera i dati delle ore lavorate per il mese e l'anno corrente
        $userId = App::Auth()->uid; // Recupera l'ID dell'utente autenticato
        $stmt = Database::Go()->pdo->prepare("
            SELECT data_lavoro, ore_lavorate 
            FROM OreLavoro 
            WHERE account_id = :account_id 
              AND YEAR(data_lavoro) = :year 
              AND MONTH(data_lavoro) = :month
        ");
        $stmt->execute([
            ':account_id' => $userId,
            ':year' => $year,
            ':month' => $month
        ]);

        $tpl->oreLavorate = $stmt->fetchAll(PDO::FETCH_ASSOC);

        // Recupera anche il totale delle ore lavorate per il mese
        $stmtTotal = Database::Go()->pdo->prepare("
            SELECT SUM(ore_lavorate) AS total_ore 
            FROM OreLavoro 
            WHERE account_id = :account_id 
              AND YEAR(data_lavoro) = :year 
              AND MONTH(data_lavoro) = :month
        ");
        $stmtTotal->execute([
            ':account_id' => $userId,
            ':year' => $year,
            ':month' => $month
        ]);
        $totalOre = $stmtTotal->fetchColumn();
        $tpl->totalOre = $totalOre;

        echo $tpl->render();
        break;
        
        
        //Password Reset
        case 'uResetPass':
        case 'aResetPass':
            App::Front()->passReset();
            break;
        
        //Register
        case 'register':
            App::Front()->Registration();
            break;
        
        //Pass Change
        case 'password':
            App::Front()->passwordChange();
            break;
        
        //Update Profile
        case 'profile':
            if (!App::Auth()->is_User()) {
                exit;
            }
            App::Front()->updateProfile();
            break;
        
        //Select Membership
        case 'buy':
            if (!App::Auth()->is_User()) {
                exit;
            }
            App::Front()->buyMembership();
            break;
        
        //Select Gateway
        case 'gateway':
            if (!App::Auth()->is_User()) {
                exit;
            }
            App::Front()->selectGateway();
            break;
        
        //Apply Coupon
        case 'coupon':
            if (!App::Auth()->is_User()) {
                exit;
            }
            App::Front()->getCoupon();
            break;
        
        case 'activateCoupon':
            if (!App::Auth()->is_User()) {
                exit;
            }
            App::Front()->activateCoupon();
            break;
        
        //Contact
        case 'contact':
            App::Front()->processContact();
            break;
        
        //Login Check
        case 'checkLogin':
            if (!App::Auth()->is_User()) {
                exit;
            }
            $json['type'] = (Database::Go()->select(User::mTable, array('id'))->where('sesid', App::Auth()->sesid, '=')->first()->run()) ? 'success' : 'error';
            print json_encode($json);
            break;
        
        //Clear Session Temp Queries
        case 'session':
            Session::remove('debug-queries');
            Session::remove('debug-warnings');
            Session::remove('debug-errors');
            print 'ok';
            break;
    endswitch;
    
/* == Get Actions == */
switch ($gAction) :
    // Invoice
    case 'invoice':
        if (!App::Auth()->is_User()) {
            exit;
        }

        if ($row = User::getInvoice(Filter::$id)) {
            $tpl = App::View(BASEPATH . 'view/front/snippets/');
            $tpl->row = $row;
            $tpl->user = Auth::$userdata;
            $tpl->core = App::Core();
            $tpl->template = 'invoice';

            $title = Validator::sanitize($row->title, 'alpha');

            require_once(BASEPATH . 'lib/mPdf/vendor/autoload.php');
            try {
                $mpdf = new Mpdf(['mode' => 'utf-8']);
                $mpdf->SetTitle($title);

                // Scrivere il contenuto HTML nel PDF
                $mpdf->WriteHTML($tpl->render());

                // Recuperare lo user ID dell'utente loggato
                $userId = Auth::$userdata->id;

                // Utilizzare lo user ID e il valore di 'txn_id' come nome del file
                $randomName = $userId . '-' . $row->txn_id . '.pdf';

                // Ottenere anno e mese corrente
                $currentYear = date('Y');
                $currentMonth = date('m');

                // Percorso base per le fatture
                $baseFatturePath = BASEPATH . '/Fatture';

                // Creare la cartella per l'anno corrente, se non esiste
                $yearPath = $baseFatturePath . '/' . $currentYear;
                if (!is_dir($yearPath)) {
                    mkdir($yearPath, 0777, true);
                }

                // Creare la cartella per il mese corrente, se non esiste
                $monthPath = $yearPath . '/' . $currentMonth;
                if (!is_dir($monthPath)) {
                    mkdir($monthPath, 0777, true);
                }

                // Percorso completo del file nella struttura /Fatture/anno/mese
                $filePath = $monthPath . '/' . $randomName;

                // Salvare il file PDF
                $mpdf->Output($filePath, 'F');

                // Percorso relativo da salvare nel database
                $relativePath = '/Fatture/' . $currentYear . '/' . $currentMonth . '/' . $randomName;

                // Aggiornare la colonna 'invoice_file' nella tabella 'payments'
                $updateResult = Database::Go()->update(
                    'payments',
                    ['invoice_file' => $relativePath],
                    ['txn_id' => $row->txn_id] // Assicurati di aggiornare per txn_id corretto
                );

                // Controllare il risultato dell'update
                if ($updateResult) {
                    // Redirect al file PDF
                    header("Location: " . $relativePath);
                    exit; // Termina l'esecuzione dopo il redirect
                } else {
                    echo "Errore nell'aggiornamento del percorso nel DB.";
                }
            } catch (MpdfException $e) {
                echo "Errore nella generazione della fattura: " . $e->getMessage();
            }
        }
        exit;
        break;

    



    // Download
    case 'download':
        if (!App::Auth()->is_User()) {
            exit;
        }
        $token = 0;
        if (Validator::get('token')) {
            $token = Validator::sanitize($_GET['token'], 'alphanumeric', 16);
        }

        if ($row = Database::Go()->select(Content::fTable)->where('token', $token, '=')->first()->run()) {
            if (!file_exists(App::Core()->file_dir . $row->name) || !is_file(App::Core()->file_dir . $row->name)) {
                Debug::addMessage('errors', 'file error', 'File does not exist. Make sure you specified correct file name.', 'session');
                Url::redirect(Url::url('/dashboard/downloads', '?msg=' . urlencode(Language::$word->FU_ERROR5)));
                exit;
            } else {
                File::download(App::Core()->file_dir . $row->name, $row->name);
            }
        } else {
            Url::redirect(Url::url('/dashboard/downloads', '?msg=' . urlencode(Language::$word->FU_ERROR6)));
        }
        break;

endswitch;
