<?php
   /**
    * dashboard
    *
    * @package Wojo Framework
    * @author wojoscripts.com
    * @copyright 2023
    * @version 5.00: dashboard.tpl.php, v1.00 7/17/2023 11:02 AM Gewa Exp $
    *
    */
   if (!defined('_WOJO')) {
      die('Direct access to this location is not allowed.');
   }
?>
<main>
   <div class="padding-vertical">
      <div class="center-align">
         <img src="<?php echo UPLOADURL; ?>/avatars/<?php echo (App::Auth()->avatar) ? App::Auth()->avatar : 'default.svg'; ?>" alt="" class="wojo normal inline rounded image">
      </div>
      <div class="wojo-grid">
         <div class="center-align margin-vertical">
            <?php
            // Connessione al database
            try {
                $pdo = new PDO(DB_DRIVER . ":host=" . DB_SERVER . ";dbname=" . DB_DATABASE, DB_USER, DB_PASS);
                $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            } catch (PDOException $e) {
                die("Errore connessione database: " . $e->getMessage());
            }

            // Recupera l'account_id dell'utente loggato tramite il sistema di autenticazione
            $accountId = App::Auth()->uid;

            // Query per controllare i certificati
            $stmt = $pdo->prepare("
                SELECT COUNT(*) AS total, 
                       MAX(expiry_date) AS latest_expiry 
                FROM Certificati 
                WHERE userid = :userid
            ");
            $stmt->execute([':userid' => $accountId]);
            $result = $stmt->fetch(PDO::FETCH_ASSOC);

            if (!$result || $result['total'] == 0) {
                // Nessun certificato trovato
                echo "<p class='wojo warning text'>Non ci sono certificati medici associati al tuo account.<br>
                      <a href='/dashboard/certificati/' class='wojo primary text'>Carica certificato</a></p>";
            } elseif (strtotime($result['latest_expiry']) < time()) {
                // Certificati scaduti
                echo "<p class='wojo warning text'>Il tuo certificato medico è scaduto. Ti preghiamo di aggiornarlo.</p><br>
                      <a href='/dashboard/certificati/' class='wojo primary text'>Carica certificato</a></p>";
            } else {
                // Certificati validi
                $expiryDate = DateTime::createFromFormat('Y-m-d', $result['latest_expiry']);
                if ($expiryDate) {
                    $formattedDate = $expiryDate->format('d/m/Y');
                    echo "<p class='wojo success text'>Tutto a posto! Il tuo certificato medico è valido fino al " . htmlspecialchars($formattedDate) . ".</p>";
                } else {
                    echo "<p class='wojo error text'>Errore: la data fornita non è valida.</p>";
                }
            }
            ?>
            
            <br><br>

            <div class="wojo stacked buttons">
               <a class="wojo secondary button active passive"><?php echo Language::$word->ADM_MEMBS; ?></a>
               <a class="wojo secondary button" href="<?php echo Url::url('/dashboard', 'history'); ?>"><?php echo Language::$word->HISTORY; ?></a>
               <a class="wojo secondary button" href="<?php echo Url::url('/dashboard', 'profile'); ?>"><?php echo Language::$word->M_SUB18; ?></a>
               <a class="wojo secondary button" href="<?php echo Url::url('/dashboard', 'downloads'); ?>"><?php echo Language::$word->DOWNLOADS; ?></a>
               <a class="wojo negative icon button" href="<?php echo Url::url('/logout'); ?>">
                  <i class="icon power"></i>
               </a>
            </div>
         </div>
         <br>
         
     <!-- Campo di ricerca -->

<div class="center-align"> Scrivi qui il tuo comune

    <input type="text" id="searchComune" placeholder="Scrivi qui il tuo comune" class="wojo input" 

        style="width: 80%; max-width: 400px; font-size: 18px; display: block; margin: 0 auto;" value=""> <!-- Imposta "palestra" come valore predefinito -->

</div>

<br>



<?php if ($this->data) : ?>

    <div class="wojo cards screen-2 tablet-2 mobile-1 phone-1 gutters" id="membershipContainer">

        <?php foreach ($this->data as $row) : ?>

            <div class="card membership-card<?php echo $this->user->membership_id == $row->id ? ' active' : null; ?>" id="item_<?php echo $row->id; ?>" data-description="<?php echo strtolower($row->description); ?>" 

                 style="<?php echo ($row->title === 'Quota Annuale Palestra') ? 'display: block;' : 'display: none;'; ?>"> <!-- Mostra solo "Quota Annuale Palestra" -->

                <div class="content">

                    <div class="center-align">

                        <?php if ($row->thumb) : ?>

                            <img src="<?php echo UPLOADURL; ?>/memberships/<?php echo $row->thumb; ?>" alt="" class="wojo large image inline">

                        <?php else : ?>

                            <img src="<?php echo UPLOADURL; ?>/memberships/default.svg" alt="" class="wojo large image inline">

                        <?php endif; ?>

                    </div>

                    <div class="center-align margin-small-vertical">

                        <h4><?php echo Utility::formatMoney($row->price); ?> <?php echo $row->title; ?></h4>

                        <p class="text-size-small basic"><?php echo $row->description; ?></p>

                        <p class="text-size-small basic"><?php echo Language::$word->MEM_REC1; ?> <?php echo ($row->recurring) ? Language::$word->YES : Language::$word->NO; ?></p>

                        <p class="text-size-small"><?php echo $row->days; ?> @ <?php echo Date::getPeriodReadable($row->period); ?></p>

                    </div>

                    <?php echo Url::out_url($row->body); ?>

                    <?php if ($this->user->membership_id != $row->id) : ?>

                        <div class="center-align">

                            <a class="wojo small primary button add-cart" data-id="<?php echo $row->id; ?>">

                                <?php echo ($row->price <> 0) ? Language::$word->M_SUB19 : Language::$word->M_SUB20; ?>

                            </a>

                        </div>

                    <?php endif; ?>

                </div>

            </div>

        <?php endforeach; ?>

    </div>

<?php endif; ?>



<script>

document.getElementById('searchComune').addEventListener('input', function() {

    let searchTerm = this.value.toLowerCase().trim();

    let cards = document.querySelectorAll('.membership-card');



    // Nascondi tutte le schede all'inizio

    cards.forEach(card => {

        card.style.display = 'none';

    });



    // Mostra solo le schede che corrispondono al termine di ricerca

    let foundMatch = false;



    cards.forEach(card => {

        let description = card.getAttribute('data-description') || ''; // Evita errori se data-description è null

        description = description.toLowerCase().trim();



        // Mostra solo le schede che corrispondono al termine di ricerca

        if (description.includes(searchTerm)) {

            card.style.display = 'block'; // Mostra la scheda se il termine di ricerca corrisponde

            foundMatch = true; // C'è una corrispondenza

        }

    });



    // Mostra "Quota Annuale Palestra" se il campo di ricerca è vuoto

    let quotaAnnualCard = document.querySelector('.membership-card[data-description*="quota annuale palestra"]');



    if (searchTerm === '') {

        // Mostra solo "Quota Annuale Palestra" quando il campo di ricerca è vuoto

        if (quotaAnnualCard) {

            quotaAnnualCard.style.display = 'block'; // Mostra "Quota Annuale Palestra"

        }

    } else if (!foundMatch) {

        // Se non ci sono corrispondenze, mostra solo "Quota Annuale Palestra"

        if (quotaAnnualCard) {

            quotaAnnualCard.style.display = 'block';

        }

    } else {

        // Nascondi "Quota Annuale Palestra" se ci sono corrispondenze

        if (quotaAnnualCard) {

            quotaAnnualCard.style.display = 'none';

        }

    }



    // Ricarica la pagina se il campo di ricerca è vuoto

    if (searchTerm === '' && this.value.length === 0) {

        window.location.reload(); // Ricarica la pagina

    }

});

</script>









         <div id="mResult"></div>
         <span style="font-weight: bold;">PER PAGAMENTI CON BONIFICO BANCARIO:</span><br>
         IBAN : IT67 L030 3223 4010 1000 0823 866 <br>
         INTESTATO A: ASD AIJJGJ <br>
         Causale: Quota mensile ( Cognome Nome della persona iscritta )      
      </div>
   </div>
</main>