<?php
   /**
    * invoice
    *
    * @package Wojo Framework
    * @author wojoscripts.com
    * @copyright 2023
    * @version 5.00: invoice.tpl.php, v1.00 7/17/2023 12:41 PM Gewa Exp $
    *
    */
   if (!defined('_WOJO')) {
      die('Direct access to this location is not allowed.');
   }
   
?>

<?php
// Connessione al database
$dsn = DB_DRIVER . ':host=' . DB_SERVER . ';dbname=' . DB_DATABASE . ';charset=utf8mb4';
$username = DB_USER;
$password = DB_PASS;

try {
    $pdo = new PDO($dsn, $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Recupero del CAP (field_id = 5)
    $userId = App::Auth()->uid; // Recupera l'ID dell'utente autenticato
    
    $stmtZip = $pdo->prepare("
        SELECT field_value 
        FROM user_custom_fields 
        WHERE user_id = :user_id AND field_id = 5
    ");
    $stmtZip->execute([
        ':user_id' => $userId
    ]);
    $userZip = $stmtZip->fetchColumn() ?: 'N/A'; // Recupera il CAP, se non trovato usa 'N/A'

    // Recupero del Codice Fiscale (field_id = 2)
    $stmtCodiceFiscale = $pdo->prepare("
        SELECT field_value 
        FROM user_custom_fields 
        WHERE user_id = :user_id AND field_id = 2
    ");
    $stmtCodiceFiscale->execute([
        ':user_id' => $userId
    ]);
    $codiceFiscale = $stmtCodiceFiscale->fetchColumn() ?: 'N/A'; // Recupera il codice fiscale, se non trovato usa 'N/A'
    
    // Recupero indirizzo (field_id = 4)
    $stmtIndirizzo = $pdo->prepare("
        SELECT field_value 
        FROM user_custom_fields 
        WHERE user_id = :user_id AND field_id = 4
    ");
    $stmtIndirizzo->execute([
        ':user_id' => $userId
    ]);
    $Indirizzo = $stmtIndirizzo->fetchColumn() ?: 'N/A'; // Recupera Indirizzo, se non trovato usa 'N/A'
    
     // Recupero comune (field_id = 1)
    $stmtComune = $pdo->prepare("
        SELECT field_value 
        FROM user_custom_fields 
        WHERE user_id = :user_id AND field_id = 1
    ");
    $stmtComune->execute([
        ':user_id' => $userId
    ]);
    $Comune = $stmtComune->fetchColumn() ?: 'N/A'; // Recupera comune, se non trovato usa 'N/A'
    
    // Recupero Nome figlio (field_id = 6)
    $stmtNomeFiglio = $pdo->prepare("
        SELECT field_value 
        FROM user_custom_fields 
        WHERE user_id = :user_id AND field_id = 6
    ");
    $stmtNomeFiglio->execute([
        ':user_id' => $userId
    ]);
    $NomeFiglio = $stmtNomeFiglio->fetchColumn() ?: ''; // Recupera nome figlio, se non trovato usa campo vuoto
    
    
    // Recupero Cognome figlio (field_id = 7)
    $stmtCognomeFiglio = $pdo->prepare("
        SELECT field_value 
        FROM user_custom_fields 
        WHERE user_id = :user_id AND field_id = 7
    ");
    $stmtCognomeFiglio->execute([
        ':user_id' => $userId
    ]);
    $CognomeFiglio = $stmtCognomeFiglio->fetchColumn() ?: ''; // Recupera cognome figlio, se non trovato usa campo vuoto
    
    // Recupero del Codice Fiscale figlio (field_id = 8)
    $stmtCodiceFiscaleFiglio = $pdo->prepare("
        SELECT field_value 
        FROM user_custom_fields 
        WHERE user_id = :user_id AND field_id = 8
    ");
    $stmtCodiceFiscaleFiglio->execute([
        ':user_id' => $userId
    ]);
    $codiceFiscaleFiglio = $stmtCodiceFiscaleFiglio->fetchColumn() ?: ''; // Recupera il codice fiscale, se non trovato usa campo vuoto
    
    

    // Stampa le variabili
   // echo "User Zip: " . $userZip . "\n";
   // echo "Codice Fiscale: " . $codiceFiscale . "\n";
   // echo "Codice Fiscale: " . $Indirizzo . "\n";
      // echo "Comune " . $Comune . "\n";


   

} catch (PDOException $e) {
    die("Errore nella connessione al database: " . $e->getMessage());
}
?>







<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="en">
<head>
   <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
   <title><?php echo Language::$word->INVOICE; ?></title>
   <style type="text/css">
      body {
         background-color: #fff;
         color: #333;
         font-family: DejaVu Serif, Helvetica, Times-Roman, serif;
         font-size: 1em;
         margin: 0;
         padding: 0
      }
      table {
         font-size: 75%;
         width: 100%;
         border-collapse: separate;
         border-spacing: 2px
      }
      th,
      td {
         position: relative;
         text-align: left;
         border-radius: .25em;
         border-style: solid;
         border-width: 1px;
         padding: .5em
      }
      th {
         background: #EEE;
         border-color: #BBB
      }
      td {
         border-color: #DDD
      }
      h1 {
         font: bold 100% sans-serif;
         letter-spacing: .5em;
         text-align: center;
         text-transform: uppercase
      }
      table.inventory {
         clear: both;
         width: 100%
      }
      table.inventory th,
      table.payments th {
         font-weight: 700;
         text-align: center
      }
      table.inventory td:nth-child(1) {
         width: 52%
      }
      table.balance th,
      table.balance td {
         width: 50%
      }
      .green {
         background-color: #D5EEBE;
         color: #689340
      }
      small {
         font-size: 75%;
         line-height: 1.5em
      }
      table.inventory td.right {
         text-align: right;
         width: 12%
      }
      table.payments td.right,
      table.balance td {
         text-align: right
      }
      @page {
         margin: 30px;
         margin-footer: 5mm;
         footer: html_footer;
      }
   </style>
</head>
<body>
<table border="0">
   <tr>
      <td style="width: 60%;" valign="top"><?php if ($this->core->plogo): ?>
            <img alt="" src="<?php echo UPLOADS . '/' . $this->core->plogo; ?>">
         <?php else: ?>
            <?php echo $this->core->company; ?>
         <?php endif; ?></td>
      <td valign="top" style="width:40%;text-align: right"><h4 style="margin:0;padding:0;font-size: 12px;">Ricevuta: #<?php echo $this->row->txn_id; ?></h4>
         <h4 style="margin:0;padding:0;font-size: 12px;"><?php echo Date::doDate('short_date', $this->row->created); ?></h4></td>
   </tr>
</table>
<div style="background-color:#ddd;height:1px">&nbsp;</div>
<table style="padding-top:25px">
   <tr>
      <td valign="top" style="width:60%">Ricevuta Emessa Da</td>
      <td colspan="2" valign="top" style="width:40%">Nome Cliente</td>
   </tr>
   <tr>
      <td valign="top" style="width:60%"><p><?php echo Validator::cleanOut($this->core->inv_info); ?></p></td>
      <td colspan="2" valign="top" style="width:40%"><p><?php echo $this->user->fname; ?> <?php echo $this->user->lname; ?><br/>
            <?php echo $Indirizzo ?><br/>
            
<?php echo $userZip; ?><br/>

<?php echo $Comune ?><br/>

<?php echo "Codice Fiscale: " . $codiceFiscale . "\n"; ?><br/><br/>


<?php 

//se solo 1 di queste 3 variabili è vuota non stampa niente

if (!empty($NomeFiglio) && !empty($CognomeFiglio) && !empty($codiceFiscaleFiglio)): ?>

    <?php echo "Nome Figlio: " . htmlspecialchars($NomeFiglio) . " " . htmlspecialchars($CognomeFiglio) . "<br/>"; ?>

    <?php echo "Codice Fiscale Figlio: " . htmlspecialchars($codiceFiscaleFiglio) . "<br/>"; ?>

<?php endif; ?>



           
           <br />  

          
  



            
            
            
            
            
            
            <br/>
            
            


            <?php echo $this->user->country; ?></p></td>
   </tr>
   <tr>
      <td valign="top" style="width:60%"><br/></td>
      <td valign="top" style="width:20%">Importo Pagato:<br/>Data Ricevuta:</td>
      <td valign="top" style="width:20%"><?php echo Utility::formatMoney($this->row->total); ?><br/>
         <?php echo Date::doDate('short_date', $this->row->created); ?></td>
   </tr>
</table>
<div style="height:20px"></div>
<table class="inventory">
   <thead>
   <tr>
      <th>
         <span>Descrizione Servizio</span>
      </th>
      <th>
         <span>Totale</span>
      </th>
   </tr>
   </thead>
   <tbody>
   <tr>
      <td>
         <span><?php echo $this->row->title; ?> <small>(<?php echo $this->row->description; ?>)</small></span>
      </td>
      <td class="right">
         <span><?php echo $this->row->rate_amount; ?></span>
      </td>
   </tr>
   <tr>
      <td align="right">Sconti/Coupon:</td>
      <td align="right">- <?php echo number_format($this->row->coupon, 2); ?></td>
   </tr>
   </tbody>
</table>
<table class="balance">
   <tr>
      <th>
         <span>Subtotale</span>
      </th>
      <td>
         <span><?php echo number_format($this->row->total - $this->row->coupon - $this->row->tax, 2); ?></span>
      </td>
   </tr>
   <tr>
      <th>
         <span>Iva</span>
      </th>
      <td>
         <span><?php echo $this->row->tax; ?></span>
      </td>
   </tr>
   <tr>
      <th>
         <span>Importo Finale</span>
      </th>
      <td>
         <span><?php echo $this->row->total; ?><?php echo $this->row->currency; ?></span>
      </td>
   </tr>
   <tr>
      <th>Stato</th>
      <td class="green">PAGATO</td>
   </tr>
</table>
<htmlpagefooter name="footer">
   <table width="100%" style="vertical-align: bottom;font-size: 8pt; border-top:1px solid #BBB; font-weight: bold; font-style: italic;">
      <tr>
         <td colspan="3" style="border:0"><?php if ($this->core->inv_note): ?>
               <?php echo Validator::cleanOut($this->core->inv_note); ?>
            <?php endif; ?></td>
      </tr>
      <tr>
         <td width="33%" style="border:0">
            <span style="font-weight: bold; font-style: italic;">{DATE j-m-Y}</span>
         </td>
         <td width="33%" align="center" style="font-weight: bold; font-style: italic;border:0">{PAGENO}/{nbpg}</td>
         <td width="33%" style="text-align: right;border:0 "><?php echo $this->core->company; ?></td>
      </tr>
   </table>
</htmlpagefooter>
</body>
</html>